/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.magic.spells.celestia;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.particle.providers.WaveParticleData;
import net.goo.brutality.registry.BrutalityModParticles;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SacrificeSpell
extends BrutalitySpell {
    public SacrificeSpell() {
        super(IBrutalitySpell.MagicSchool.CELESTIA, List.of(IBrutalitySpell.SpellCategory.INSTANT, IBrutalitySpell.SpellCategory.AOE, IBrutalitySpell.SpellCategory.BUFF), "sacrifice", 80, 0.0f, 600, 0, 1, List.of(new BrutalityTooltipHelper.SpellStatComponent(BrutalityTooltipHelper.SpellStatComponents.HEALING, 10.0f, 2.0f, null, null), new BrutalityTooltipHelper.SpellStatComponent(BrutalityTooltipHelper.SpellStatComponents.RANGE, 5.0f, 1.0f, null, Float.valueOf(25.0f))));
    }

    @Override
    public float getDamageLevelScaling() {
        return 0.0f;
    }

    @Override
    public float getManaCostLevelScaling() {
        return 10.0f;
    }

    @Override
    public int getCooldownLevelScaling() {
        return -5;
    }

    @Override
    public boolean onStartCast(Player player, ItemStack stack, int spellLevel) {
        BrutalityTooltipHelper.SpellStatComponent healthStat = this.getStat(BrutalityTooltipHelper.SpellStatComponents.HEALING);
        float healPool = this.getFinalStat(spellLevel, healthStat);
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WaveParticleData waveParticleData = new WaveParticleData((ParticleType)BrutalityModParticles.HEAL_WAVE.get(), this.getFinalStat(spellLevel, this.getStat(BrutalityTooltipHelper.SpellStatComponents.RANGE)), 20);
            serverLevel.m_8767_(waveParticleData, player.m_20185_(), player.m_20227_(0.1), player.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        List<Player> nearbyPlayers = ModUtils.getEntitiesInSphere(Player.class, (Entity)player, p -> p != player, this.getFinalStat(spellLevel, this.getStat(BrutalityTooltipHelper.SpellStatComponents.RANGE)));
        float casterMissingHealth = player.m_21233_() - player.m_21223_();
        float casterHealAmount = Math.min(casterMissingHealth, healPool);
        player.m_5634_(casterHealAmount);
        healPool -= casterHealAmount;
        if (healPool < 0.0f) {
            return true;
        }
        float excessHealing = 0.0f;
        if (!nearbyPlayers.isEmpty()) {
            float healingPerPlayer = healPool / (float)nearbyPlayers.size();
            for (Player receiver : nearbyPlayers) {
                float requiredHealing = receiver.m_21233_() - receiver.m_21223_();
                if (requiredHealing < healingPerPlayer) {
                    receiver.m_5634_(requiredHealing);
                    excessHealing += healingPerPlayer - requiredHealing;
                    continue;
                }
                receiver.m_5634_(healingPerPlayer);
            }
        } else {
            return true;
        }
        if (excessHealing > 0.0f) {
            ArrayList<Player> eligiblePlayers = new ArrayList<Player>(nearbyPlayers);
            while (excessHealing > 0.0f && !eligiblePlayers.isEmpty()) {
                Player lowestHealthPlayer = eligiblePlayers.stream().min(Comparator.comparingDouble(p -> p.m_21223_() / p.m_21233_())).orElse(null);
                float requiredHealing = lowestHealthPlayer.m_21233_() - lowestHealthPlayer.m_21223_();
                if (requiredHealing <= 0.001f) {
                    eligiblePlayers.remove(lowestHealthPlayer);
                    continue;
                }
                if (requiredHealing < excessHealing) {
                    lowestHealthPlayer.m_5634_(requiredHealing);
                    excessHealing -= requiredHealing;
                    eligiblePlayers.remove(lowestHealthPlayer);
                    continue;
                }
                lowestHealthPlayer.m_5634_(excessHealing);
                break;
            }
        }
        return true;
    }
}

