/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.magic;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.magic.SpellRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SpellStorage {
    private static final String SPELLS_TAG = "Spells";
    private static final String SPELL_ID_TAG = "SpellId";
    private static final String SPELL_LEVEL_TAG = "SpellLevel";
    private static final String SELECTED_SPELL_INDEX = "SelectedSpellIndex";

    public static List<SpellEntry> getSpells(ItemStack stack) {
        ArrayList<SpellEntry> spells = new ArrayList<SpellEntry>();
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(SPELLS_TAG)) {
            return spells;
        }
        ListTag spellsTag = stack.m_41783_().m_128437_(SPELLS_TAG, 10);
        for (int i = 0; i < spellsTag.size(); ++i) {
            CompoundTag spellTag = spellsTag.m_128728_(i);
            ResourceLocation spellId = ResourceLocation.parse((String)spellTag.m_128461_(SPELL_ID_TAG));
            int level = spellTag.m_128451_(SPELL_LEVEL_TAG);
            IBrutalitySpell spell = SpellRegistry.getSpell(spellId);
            if (spell == null) continue;
            spells.add(new SpellEntry(spell, level));
        }
        return spells;
    }

    public static SpellEntry getCurrentSpellEntry(ItemStack stack) {
        List<SpellEntry> spells = SpellStorage.getSpells(stack);
        if (spells.isEmpty()) {
            return null;
        }
        int selectedIndex = stack.m_41784_().m_128451_(SELECTED_SPELL_INDEX);
        selectedIndex = Math.max(0, Math.min(selectedIndex, spells.size() - 1));
        return spells.get(selectedIndex);
    }

    public static boolean addSpell(ItemStack stack, IBrutalitySpell spell, int level) {
        CompoundTag tag = stack.m_41784_();
        ListTag spellsTag = tag.m_128441_(SPELLS_TAG) ? tag.m_128437_(SPELLS_TAG, 10) : new ListTag();
        ResourceLocation spellId = SpellStorage.getSpellId(spell);
        for (int i = 0; i < spellsTag.size(); ++i) {
            if (!spellsTag.m_128728_(i).m_128461_(SPELL_ID_TAG).equals(spellId.toString())) continue;
            spellsTag.m_128728_(i).m_128405_(SPELL_LEVEL_TAG, level);
            tag.m_128365_(SPELLS_TAG, (Tag)spellsTag);
            return true;
        }
        CompoundTag newSpellTag = new CompoundTag();
        newSpellTag.m_128359_(SPELL_ID_TAG, spellId.toString());
        newSpellTag.m_128405_(SPELL_LEVEL_TAG, level);
        spellsTag.add((Object)newSpellTag);
        tag.m_128365_(SPELLS_TAG, (Tag)spellsTag);
        if (spellsTag.size() == 1) {
            tag.m_128405_(SELECTED_SPELL_INDEX, 0);
        }
        return true;
    }

    public static boolean removeSpell(ItemStack stack, IBrutalitySpell spell) {
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        ListTag spellsTag = tag.m_128441_(SPELLS_TAG) ? tag.m_128437_(SPELLS_TAG, 10) : new ListTag();
        ResourceLocation spellId = SpellStorage.getSpellId(spell);
        int removedIndex = -1;
        for (int i = 0; i < spellsTag.size(); ++i) {
            if (!spellsTag.m_128728_(i).m_128461_(SPELL_ID_TAG).equals(spellId.toString())) continue;
            spellsTag.remove(i);
            removedIndex = i;
            break;
        }
        if (removedIndex != -1) {
            int selectedIndex;
            tag.m_128365_(SPELLS_TAG, (Tag)spellsTag);
            if (tag.m_128441_(SELECTED_SPELL_INDEX) && removedIndex <= (selectedIndex = tag.m_128451_(SELECTED_SPELL_INDEX))) {
                tag.m_128405_(SELECTED_SPELL_INDEX, Math.max(0, Math.min(selectedIndex, spellsTag.size() - 1)));
            }
            if (spellsTag.isEmpty()) {
                tag.m_128473_(SELECTED_SPELL_INDEX);
            }
            return true;
        }
        return false;
    }

    public static boolean setSelectedSpell(ItemStack stack, int index) {
        List<SpellEntry> spells = SpellStorage.getSpells(stack);
        if (index < 0 || index >= spells.size()) {
            return false;
        }
        stack.m_41784_().m_128405_(SELECTED_SPELL_INDEX, index);
        return true;
    }

    public static boolean cycleSelectedSpell(ItemStack stack, int direction) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(SPELLS_TAG)) {
            return false;
        }
        ListTag spellsTag = stack.m_41783_().m_128437_(SPELLS_TAG, 10);
        if (spellsTag.isEmpty()) {
            return false;
        }
        int currentIndex = stack.m_41783_().m_128451_(SELECTED_SPELL_INDEX);
        int newIndex = currentIndex + direction;
        if (newIndex >= spellsTag.size()) {
            newIndex = 0;
        }
        if (newIndex < 0) {
            newIndex = spellsTag.size() - 1;
        }
        stack.m_41783_().m_128405_(SELECTED_SPELL_INDEX, newIndex);
        return true;
    }

    private static ResourceLocation getSpellId(IBrutalitySpell spell) {
        return ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)spell.getSpellName().toLowerCase(Locale.ROOT));
    }

    public record SpellEntry(IBrutalitySpell spell, int level) {
    }
}

