/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.magic;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.goo.brutality.item.weapon.tome.BaseMagicTome;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.magic.SpellCooldownTracker;
import net.goo.brutality.magic.SpellRegistry;
import net.goo.brutality.magic.SpellStorage;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SpellCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spell").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"spell_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (ResourceLocation spellId : SpellRegistry.SPELLS.keySet()) {
                builder.suggest(SpellRegistry.getSpell(spellId).getSpellName());
            }
            return builder.buildFuture();
        }).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(SpellCommands::addSpellToHeldItem))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"spell_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (ResourceLocation spellId : SpellRegistry.SPELLS.keySet()) {
                builder.suggest(SpellRegistry.getSpell(spellId).getSpellName());
            }
            return builder.buildFuture();
        }).executes(SpellCommands::removeSpellFromHeldItem)))).then(Commands.m_82127_((String)"cooldowns").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).suggests((context, builder) -> {
            for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
                builder.suggest(player.m_7755_().getString());
            }
            return builder.buildFuture();
        }).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            SpellCooldownTracker.resetCooldowns((Player)player);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Cooldowns reset for " + player.m_7755_().getString())), true);
            return 1;
        })))));
    }

    private static int addSpellToHeldItem(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String spellName = StringArgumentType.getString(context, (String)"spell_name");
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack heldItem = player.m_21205_();
        if (!(heldItem.m_41720_() instanceof BaseMagicTome)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You must be holding a magic tome!"));
            return 0;
        }
        ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)spellName.toLowerCase());
        IBrutalitySpell spell = SpellRegistry.getSpell(spellId);
        if (spell == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown spell: " + spellName)));
            return 0;
        }
        if (SpellStorage.addSpell(heldItem, spell, level)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Added spell " + spellName + " at level " + level)), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to add spell"));
        return 0;
    }

    private static int removeSpellFromHeldItem(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String spellName = StringArgumentType.getString(context, (String)"spell_name");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack heldItem = player.m_21205_();
        if (!(heldItem.m_41720_() instanceof BaseMagicTome)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You must be holding a magic tome!"));
            return 0;
        }
        ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)spellName.toLowerCase());
        IBrutalitySpell spell = SpellRegistry.getSpell(spellId);
        if (spell == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown spell: " + spellName)));
            return 0;
        }
        if (SpellStorage.removeSpell(heldItem, spell)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed spell " + spellName)), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to remove spell"));
        return 0;
    }
}

