/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.magic;

import net.goo.brutality.entity.capabilities.EntityCapabilities;
import net.goo.brutality.event.SpellCastEvent;
import net.goo.brutality.item.weapon.tome.BaseMagicTome;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.magic.SpellCooldownTracker;
import net.goo.brutality.magic.SpellStorage;
import net.goo.brutality.network.ClientboundSyncCapabilitiesPacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class SpellCastingHandler {
    public static boolean castInstantSpell(Player player, ItemStack stack, IBrutalitySpell spell, int spellLevel) {
        CastConditionResult result = SpellCastingHandler.checkAllConditions(player, spell, spellLevel);
        if (!result.canCast()) {
            if (player.m_9236_().m_5776_()) {
                player.m_5661_(result.feedback(), true);
            }
            return false;
        }
        SpellCastEvent.Pre event = new SpellCastEvent.Pre(player, stack, spell, spellLevel);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.isCanceled()) {
            return false;
        }
        if (spell.onStartCast(player, stack, spellLevel)) {
            spell.onEndCast(player, stack, spellLevel);
            SpellCastingHandler.decrementManaAndStartCooldown(player, spell, spellLevel);
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(player, stack, spell, spellLevel));
            return true;
        }
        return false;
    }

    public static boolean startContinuousCast(Player player, ItemStack stack, IBrutalitySpell spell, int spellLevel) {
        CastConditionResult result = SpellCastingHandler.checkAllConditions(player, spell, spellLevel);
        if (!result.canCast()) {
            if (player.m_9236_().m_5776_()) {
                player.m_5661_(result.feedback(), true);
            }
            return false;
        }
        SpellCastEvent.Pre event = new SpellCastEvent.Pre(player, stack, spell, spellLevel);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.isCanceled()) {
            return false;
        }
        if (spell.onStartCast(player, stack, spellLevel)) {
            SpellCastingHandler.handleSpellManaCost(player, spell, spellLevel);
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(player, stack, spell, spellLevel));
            return true;
        }
        return false;
    }

    public static void tickContinuousCast(Player player, ItemStack stack, IBrutalitySpell spell, int spellLevel) {
        CastConditionResult result = SpellCastingHandler.checkAllConditions(player, spell, spellLevel);
        if (result.canCast()) {
            spell.onCastTick(player, stack, spellLevel);
            SpellCastingHandler.handleSpellManaCost(player, spell, spellLevel);
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(player, stack, spell, spellLevel));
        }
    }

    public static void endContinuousCast(Player player, ItemStack stack, IBrutalitySpell spell, int spellLevel) {
        spell.onEndCast(player, stack, spellLevel);
        SpellCooldownTracker.setCooldown(player, spell, spellLevel);
        MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(player, stack, spell, spellLevel));
    }

    public static boolean castChannellingSpell(Player player, ItemStack stack, IBrutalitySpell spell, int spellLevel, int remainingTicks) {
        CastConditionResult result = SpellCastingHandler.checkAllConditions(player, spell, spellLevel);
        if (!result.canCast()) {
            if (player.m_9236_().m_5776_()) {
                player.m_5661_(result.feedback(), true);
            }
            return false;
        }
        int castTime = IBrutalitySpell.getActualCastTime(player, spell, spellLevel);
        if (remainingTicks <= stack.m_41779_() - castTime) {
            SpellCastEvent.Pre event = new SpellCastEvent.Pre(player, stack, spell, spellLevel);
            if (MinecraftForge.EVENT_BUS.post((Event)event) || event.isCanceled()) {
                return false;
            }
            if (spell.onStartCast(player, stack, spellLevel)) {
                spell.onEndCast(player, stack, spellLevel);
                SpellCastingHandler.decrementManaAndStartCooldown(player, spell, spellLevel);
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(player, stack, spell, spellLevel));
                return true;
            }
        }
        return false;
    }

    private static void handleSpellManaCost(Player player, IBrutalitySpell spell, int spellLevel) {
        SpellCastingHandler.getManaHandler(player).ifPresent(cap -> cap.decrementMana(player, spell, spellLevel, IBrutalitySpell.getActualManaCost(player, spell, spellLevel)));
        if (!player.m_9236_().m_5776_()) {
            PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(player.m_19879_(), (Entity)player));
        }
    }

    public static void addMana(Player player, float amount) {
        SpellCastingHandler.getManaHandler(player).ifPresent(cap -> cap.incrementMana(amount));
        if (!player.m_9236_().m_5776_()) {
            PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(player.m_19879_(), (Entity)player));
        }
    }

    public static void decrementManaAndStartCooldown(Player player, IBrutalitySpell spell, int spellLevel) {
        SpellCastingHandler.handleSpellManaCost(player, spell, spellLevel);
        SpellCooldownTracker.setCooldown(player, spell, spellLevel);
    }

    @NotNull
    public static LazyOptional<EntityCapabilities.PlayerManaCap> getManaHandler(Player player) {
        return player.getCapability(BrutalityCapabilities.PLAYER_MANA_CAP);
    }

    public static boolean hasEnoughMana(Player player, IBrutalitySpell spell, int level) {
        if (player.m_9236_().m_5776_()) {
            return false;
        }
        return SpellCastingHandler.getManaHandler(player).map(cap -> {
            float cost = IBrutalitySpell.getActualManaCost(player, spell, level);
            if (cap.manaValue() >= cost) {
                PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(player.m_19879_(), (Entity)player));
                return true;
            }
            return false;
        }).orElse(false);
    }

    public static CastConditionResult checkMana(Player player, IBrutalitySpell spell, int spellLevel) {
        if (!SpellCastingHandler.hasEnoughMana(player, spell, spellLevel)) {
            return new CastConditionResult(false, (Component)Component.m_237115_((String)"message.brutality.no_mana").m_130940_(ChatFormatting.RED));
        }
        return new CastConditionResult(true, null);
    }

    public static CastConditionResult checkCooldown(Player player, IBrutalitySpell spell) {
        if (SpellCooldownTracker.isOnCooldown(player, spell)) {
            int remaining = SpellCooldownTracker.getRemainingTicks(player, spell);
            MutableComponent feedback = Component.m_237115_((String)"message.brutality.on_cooldown").m_130946_(String.valueOf(remaining / 20)).m_7220_((Component)Component.m_237115_((String)"message.brutality.seconds")).m_130940_(ChatFormatting.RED);
            return new CastConditionResult(false, (Component)feedback);
        }
        return new CastConditionResult(true, null);
    }

    public static CastConditionResult checkAllConditions(Player player, IBrutalitySpell spell, int spellLevel) {
        CastConditionResult manaResult = SpellCastingHandler.checkMana(player, spell, spellLevel);
        if (!manaResult.canCast()) {
            return manaResult;
        }
        CastConditionResult cooldownResult = SpellCastingHandler.checkCooldown(player, spell);
        if (!cooldownResult.canCast()) {
            return cooldownResult;
        }
        return new CastConditionResult(true, null);
    }

    public static boolean currentlyChannellingSpell(Player player, ItemStack stack) {
        if (stack.m_41720_() instanceof BaseMagicTome) {
            SpellStorage.SpellEntry currentSpell = SpellStorage.getCurrentSpellEntry(stack);
            if (currentSpell == null) {
                return false;
            }
            if (currentSpell.spell().getCategories().contains((Object)IBrutalitySpell.SpellCategory.CHANNELLING)) {
                return player.m_6117_() && !SpellCooldownTracker.isOnCooldown(player, currentSpell.spell());
            }
        }
        return false;
    }

    public static boolean currentlyCastingContinuousSpell(Player player, ItemStack stack) {
        if (stack.m_41720_() instanceof BaseMagicTome) {
            SpellStorage.SpellEntry currentSpell = SpellStorage.getCurrentSpellEntry(stack);
            if (currentSpell == null) {
                return false;
            }
            if (currentSpell.spell().getCategories().contains((Object)IBrutalitySpell.SpellCategory.CONTINUOUS)) {
                return player.m_6117_() && !SpellCooldownTracker.isOnCooldown(player, currentSpell.spell());
            }
        }
        return false;
    }

    public static float getChannellingProgress(Player player, ItemStack stack) {
        if (stack.m_41720_() instanceof BaseMagicTome) {
            SpellStorage.SpellEntry currentSpell = SpellStorage.getCurrentSpellEntry(stack);
            if (currentSpell == null) {
                return 0.0f;
            }
            if (currentSpell.spell().getCategories().contains((Object)IBrutalitySpell.SpellCategory.CHANNELLING)) {
                return (float)(stack.m_41779_() - player.m_21212_()) / (float)IBrutalitySpell.getActualCastTime(player, currentSpell.spell(), currentSpell.level());
            }
        }
        return 0.0f;
    }

    public record CastConditionResult(boolean canCast, Component feedback) {
    }
}

