/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.sword;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.goo.brutality.item.base.BrutalitySwordItem;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraftforge.common.ForgeMod;

public class VoidKnifeSword
extends BrutalitySwordItem {
    UUID VOID_KNIFE_RANGE_UUID = UUID.fromString("aefaa05a-6817-4539-b933-47baaba4b8e8");

    public VoidKnifeSword(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, attacker -> attacker.m_21166_(EquipmentSlot.MAINHAND));
        if (pTarget.m_21023_((MobEffect)BrutalityModMobEffects.SCORED.get())) {
            int amplifier = Objects.requireNonNull(pTarget.m_21124_((MobEffect)BrutalityModMobEffects.SCORED.get())).m_19564_();
            if (amplifier > 3) {
                return true;
            }
            pTarget.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SCORED.get(), 60, amplifier + 1));
        }
        pTarget.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SCORED.get(), 60, 0));
        pTarget.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.PULVERIZED.get(), 3, 3));
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(modifiers);
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(this.VOID_KNIFE_RANGE_UUID, "Reach bonus", 2.0, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return modifiers;
    }
}

