/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.sword;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.base.BrutalitySwordItem;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class MeloncholySword
extends BrutalitySwordItem {
    UUID MELONCHOLY_RANGE_UUID = UUID.fromString("cf4d35ec-1bc4-482f-89a9-6bd2d43d2c25");

    public MeloncholySword(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    public int getMaxDamage(ItemStack stack) {
        return 100;
    }

    @Override
    public float shadowSize() {
        return 1.0f;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        entity.m_9236_().m_5594_(null, entity.m_20097_(), (SoundEvent)BrutalityModSounds.SQUELCH.get(), SoundSource.PLAYERS, 10.0f, Mth.m_216267_((RandomSource)entity.m_217043_(), (float)0.8f, (float)1.2f));
        return super.onEntitySwing(stack, entity);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pAttacker.m_9236_().m_5594_(null, pAttacker.m_20097_(), (SoundEvent)BrutalityModSounds.SQUELCH.get(), SoundSource.PLAYERS, 10.0f, Mth.m_216267_((RandomSource)pAttacker.m_217043_(), (float)0.8f, (float)1.2f));
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(modifiers);
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(this.MELONCHOLY_RANGE_UUID, "Reach bonus", 2.0, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return modifiers;
    }
}

