/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.sword;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.base.BrutalitySwordItem;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class GoldKnifeSword
extends BrutalitySwordItem {
    UUID GOLD_KNIFE_RANGE_UUID = UUID.fromString("57667a41-a6c7-4412-aced-64ded0e9ded9");

    public GoldKnifeSword(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, attacker -> attacker.m_21166_(EquipmentSlot.MAINHAND));
        if (pTarget.m_21023_((MobEffect)BrutalityModMobEffects.SCORED.get())) {
            int amplifier = pTarget.m_21124_((MobEffect)BrutalityModMobEffects.SCORED.get()).m_19564_();
            if (amplifier > 2) {
                return true;
            }
            pTarget.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SCORED.get(), 60, amplifier + 1));
        }
        pTarget.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SCORED.get(), 60, 0));
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(modifiers);
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(this.GOLD_KNIFE_RANGE_UUID, "Reach bonus", 2.0, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return modifiers;
    }
}

