/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.sword;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.goo.brutality.item.base.BrutalitySwordItem;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class DoubleDown
extends BrutalitySwordItem {
    public DoubleDown(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        super.m_5551_(pStack, pLevel, pLivingEntity, pTimeCharged);
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (!pLevel.m_5776_()) {
                ItemStack randomSword = this.getRandomSword(player);
                randomSword.m_41784_().m_128379_("fromDoubleDown", true);
                player.m_150109_().m_6836_(player.m_150109_().f_35977_, randomSword);
            }
        }
    }

    private Map<Item, Double> calculateSwordRarity(Player player) {
        int luckAmplifier = player.m_21023_(MobEffects.f_19621_) ? Objects.requireNonNull(player.m_21124_(MobEffects.f_19621_)).m_19564_() + 1 : 0;
        double luckFactor = 0.5 + (double)(luckAmplifier * 2);
        List<SwordData> swordData = this.getSortedSwordData();
        if (swordData.isEmpty()) {
            return Map.of((Item)BrutalityModItems.DOUBLE_DOWN.get(), 100.0);
        }
        double[] baseWeights = swordData.stream().mapToDouble(data -> 1.0 / data.eDps).toArray();
        double[] adjustedWeights = new double[baseWeights.length];
        double weightSum = 0.0;
        for (int i = 0; i < baseWeights.length; ++i) {
            double positionFactor = 1.0 - (double)i / (double)baseWeights.length;
            adjustedWeights[i] = baseWeights[i] * Math.pow(luckFactor, 3.0 * positionFactor);
            weightSum += adjustedWeights[i];
        }
        LinkedHashMap<Item, Double> rarityMap = new LinkedHashMap<Item, Double>();
        for (int i = 0; i < swordData.size(); ++i) {
            double percentage = adjustedWeights[i] / weightSum * 100.0;
            rarityMap.put(swordData.get((int)i).item, percentage);
        }
        return rarityMap;
    }

    private List<SwordData> getSortedSwordData() {
        return ForgeRegistries.ITEMS.getValues().stream().filter(sword -> sword instanceof SwordItem || sword.m_7968_().m_204117_(ItemTags.f_271388_)).map(this::getSwordData).filter(data -> data.eDps > 0.0).sorted(Comparator.comparingDouble(SwordData::eDps).reversed()).toList();
    }

    private SwordData getSwordData(Item sword) {
        Multimap attributes = sword.getAttributeModifiers(EquipmentSlot.MAINHAND, sword.m_7968_());
        double damage = 0.0;
        double speed = 0.0;
        Collection damageModifiers = attributes.get((Object)Attributes.f_22281_);
        Collection speedModifiers = attributes.get((Object)Attributes.f_22283_);
        if (!speedModifiers.isEmpty()) {
            damage = ((AttributeModifier)damageModifiers.iterator().next()).m_22218_();
        }
        if (!speedModifiers.isEmpty()) {
            speed = -((AttributeModifier)speedModifiers.iterator().next()).m_22218_();
        }
        double eDps = damage * speed;
        return new SwordData(sword, eDps);
    }

    public ItemStack getRandomSword(Player player) {
        Map<Item, Double> rarityMap = this.calculateSwordRarity(player);
        double roll = player.m_217043_().m_188500_() * 100.0;
        double cumulative = 0.0;
        for (Map.Entry<Item, Double> entry : rarityMap.entrySet()) {
            if (!(roll <= (cumulative += entry.getValue().doubleValue()))) continue;
            return entry.getKey().m_7968_();
        }
        return ItemStack.f_41583_;
    }

    private record SwordData(Item item, double eDps) {
    }
}

