/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.sword;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.entity.projectile.generic.AbyssProjectile;
import net.goo.brutality.item.base.BrutalitySwordItem;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.ProjectileHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.ModList;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class ChallengerDeepSword
extends BrutalitySwordItem {
    UUID CHALLENGER_DEEP_RANGE__UUID = UUID.fromString("869fb9a7-237b-4b26-9f03-c04dcecea752");

    public ChallengerDeepSword(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(modifiers);
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(this.CHALLENGER_DEEP_RANGE__UUID, "Reach bonus", 4.0, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return modifiers;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (!ModList.get().isLoaded("bettercombat") && entity instanceof Player) {
            Player player = (Player)entity;
            this.performChallengerDeepAttack(stack, player);
        }
        return super.onEntitySwing(stack, entity);
    }

    public void performChallengerDeepAttack(ItemStack stack, Player player) {
        Level level = player.m_9236_();
        if (player.m_36335_().m_41519_(stack.m_41720_())) {
            return;
        }
        for (int i = 1; i <= 360; i += 30) {
            ProjectileHelper.shootProjectile(() -> new AbyssProjectile((EntityType<? extends ThrowableProjectile>)((EntityType)BrutalityModEntities.ABYSS_PROJECTILE.get()), level), player, level, 0.5f, false, Float.valueOf(0.0f), i);
        }
        player.m_36335_().m_41524_(stack.m_41720_(), 10);
    }
}

