/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.hammer;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.base.BrutalityGeoItem;
import net.goo.brutality.item.base.BrutalityHammerItem;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class SpatulaHammer
extends BrutalityHammerItem
implements BrutalityGeoItem {
    UUID SPATULA_RANGE_UUID = UUID.fromString("04227c30-b19d-4ad3-afbb-025548796f5a");

    public SpatulaHammer(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    @Override
    public boolean m_7579_(ItemStack pStack, @NotNull LivingEntity pTarget, @NotNull LivingEntity pAttacker) {
        pAttacker.m_9236_().m_247517_(null, pAttacker.m_20097_(), ModUtils.getRandomSound(BrutalityModSounds.SPATULA), SoundSource.PLAYERS);
        pTarget.m_5997_(0.0, 0.5, 0.0);
        pTarget.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.MASHED.get(), 60, 0, false, true));
        pTarget.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SCORED.get(), 60, 0, false, true));
        if (pTarget instanceof ServerPlayer) {
            ServerPlayer playerTarget = (ServerPlayer)pTarget;
            playerTarget.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)playerTarget));
        }
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(modifiers);
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(this.SPATULA_RANGE_UUID, "Reach bonus", 2.0, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return modifiers;
    }
}

