/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.generic;

import java.util.List;
import net.goo.brutality.entity.projectile.ray.ExplosionRay;
import net.goo.brutality.item.base.BrutalityGenericItem;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.ModExplosionHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

@Mod.EventBusSubscriber(modid="brutality")
public class FirstExplosionStaff
extends BrutalityGenericItem {
    private int randYaw;
    private int randPitch;
    private int circleCount = 0;
    private BlockPos targetBlockPos;
    private static final String SUCCESSFUL = "Successful";

    public FirstExplosionStaff(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41784_().m_128379_(SUCCESSFUL, true);
        return stack;
    }

    @SubscribeEvent
    public static void onFOVModifier(ComputeFovModifierEvent event) {
        ItemStack itemStack;
        Player player = event.getPlayer();
        if (player.m_6117_() && (itemStack = player.m_21211_()).m_41720_() instanceof FirstExplosionStaff) {
            event.setNewFovModifier(event.getFovModifier() * 1.5f);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack pStack = pPlayer.m_21120_(pUsedHand);
        pPlayer.m_6672_(pUsedHand);
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            this.triggerAnim((Entity)pPlayer, GeoItem.getOrAssignId((ItemStack)pStack, (ServerLevel)serverLevel), "controller", "use");
            pStack.m_41784_().m_128379_(SUCCESSFUL, true);
            this.targetBlockPos = ModUtils.getBlockLookingAt(pPlayer, false, 300.0f);
            this.randPitch = pLevel.f_46441_.m_216332_(-15, 16);
            this.randYaw = pLevel.f_46441_.m_216332_(0, 361);
            for (int i = 0; i < 2; ++i) {
            }
        }
        return InteractionResultHolder.m_19096_((Object)pPlayer.m_21120_(pUsedHand));
    }

    private void spawnExplosionSpellMagicCircles(ServerLevel level, Player player, int step) {
        if (this.targetBlockPos == null) {
            return;
        }
        double pitchRad = Math.toRadians(this.randPitch);
        double yawRad = Math.toRadians(this.randYaw);
        Vec3 startPos = Vec3.m_82512_((Vec3i)this.targetBlockPos);
        int baseHeight = 14;
        int circleStep = 8;
        int height = baseHeight + circleStep * step;
        double radius = (double)height * Math.tan(pitchRad);
        double xOffset = radius * Math.sin(yawRad);
        double zOffset = radius * Math.cos(yawRad);
        Vec3 position = new Vec3(startPos.f_82479_ + xOffset, startPos.f_82480_ + (double)height, startPos.f_82481_ + zOffset);
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        int useDuration = this.m_8105_(pStack) - pRemainingUseDuration;
        String identifier = pStack.m_41778_();
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            if (pLivingEntity instanceof Player) {
                Player player = (Player)pLivingEntity;
                if (useDuration % 20 == 0) {
                    if (this.circleCount < 10) {
                        ++this.circleCount;
                        this.spawnExplosionSpellMagicCircles(serverLevel, player, this.circleCount);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)("item.brutality." + identifier + ".maximum")).m_130940_(ChatFormatting.DARK_RED).m_130940_(ChatFormatting.BOLD), true);
                    }
                }
                pLivingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 10, false, false));
            }
        }
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            if (pEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)pEntity;
                if (!pStack.m_41784_().m_128471_(SUCCESSFUL)) {
                    this.triggerAnim((Entity)livingEntity, GeoItem.getOrAssignId((ItemStack)pStack, (ServerLevel)serverLevel), "controller", "release");
                }
            }
        }
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        if (pLivingEntity instanceof Player) {
            Player pPlayer = (Player)pLivingEntity;
            if (!pLevel.m_5776_()) {
                this.triggerAnim((Entity)pPlayer, GeoItem.getOrAssignId((ItemStack)pStack, (ServerLevel)((ServerLevel)pLevel)), "controller", "release");
                if (pStack.m_41784_().m_128471_(SUCCESSFUL)) {
                    int explosionSize = this.circleCount * 3;
                    int fatigueTime = 200 * explosionSize;
                    pPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19597_, fatigueTime, 1));
                    pPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19599_, fatigueTime, 1));
                    pPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19613_, fatigueTime, 1));
                    ExplosionRay explosionRay = new ExplosionRay((EntityType)BrutalityModEntities.EXPLOSION_RAY.get(), pLevel);
                    explosionRay.setOwner(pPlayer.m_20148_());
                    explosionRay.setPitch(this.randPitch);
                    explosionRay.setYaw(this.randYaw);
                    explosionRay.setCircleCount(this.circleCount);
                    explosionRay.m_6034_(this.targetBlockPos.m_252807_().f_82479_, this.targetBlockPos.m_123342_(), this.targetBlockPos.m_252807_().f_82481_);
                    pLevel.m_7967_((Entity)explosionRay);
                    ModExplosionHelper.Server.addExplosion(pLevel, (Entity)pPlayer, explosionRay.m_20183_(), explosionSize, 3);
                } else {
                    pLivingEntity.m_6469_(pLivingEntity.m_269291_().m_269104_((Entity)pLivingEntity, (Entity)pLivingEntity), (float)this.circleCount);
                }
                this.circleCount = 0;
            }
        }
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)item, (ServerLevel)serverLevel), "controller", "idle");
        }
        return super.onDroppedByPlayer(item, player);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", state -> state.setAndContinue(RawAnimation.begin().thenPlay("idle"))).triggerableAnim("use", RawAnimation.begin().thenPlay("use").thenPlayAndHold("using")).triggerableAnim("release", RawAnimation.begin().thenPlayAndHold("release").thenPlayAndHold("idle"))});
    }
}

