/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.generic;

import java.util.List;
import net.goo.brutality.item.base.BrutalityGenericItem;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class DoomfistGauntletItem
extends BrutalityGenericItem {
    private static final String PUNCHING = "isPunching";
    private static int clampedTime;
    int tickCount = 0;

    public DoomfistGauntletItem(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        if (!pLevel.f_46443_ && pLivingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pLivingEntity;
            pTimeCharged = 72000 - pTimeCharged;
            clampedTime = Math.min(pTimeCharged, 32);
            float movementScale = (float)clampedTime * 0.15f;
            player.m_246865_(this.getPunchDirection(player).m_82490_((double)movementScale));
            player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
            pStack.m_41784_().m_128379_(PUNCHING, true);
            player.m_36335_().m_41524_(pStack.m_41720_(), 80);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack pStack = pPlayer.m_21120_(pUsedHand);
        pStack.m_41784_().m_128379_(PUNCHING, false);
        pPlayer.m_6672_(pUsedHand);
        return InteractionResultHolder.m_19096_((Object)pStack);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pIsSelected && !pLevel.f_46443_ && pEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pEntity;
            if (pStack.m_41784_().m_128471_(PUNCHING)) {
                AABB boundingBox = new AABB(player.m_20185_() - 1.0, player.m_20186_() - 0.75, player.m_20189_(), player.m_20185_() + 1.0, player.m_20186_() + 0.75, player.m_20189_() + 1.0);
                List nearbyEntities = pLevel.m_45971_(LivingEntity.class, TargetingConditions.f_26872_, (LivingEntity)pEntity, boundingBox);
                if (!nearbyEntities.isEmpty()) {
                    LivingEntity firstTarget = (LivingEntity)nearbyEntities.get(0);
                    List targetList = pLevel.m_45971_(LivingEntity.class, TargetingConditions.f_26872_, firstTarget, firstTarget.m_20191_().m_82400_(2.0));
                    targetList.add(firstTarget);
                    for (LivingEntity target : targetList) {
                        float damageDone = (float)((double)clampedTime / 2.5);
                        target.m_6469_(target.m_269291_().m_269515_(), damageDone);
                        target.m_20256_(target.m_20184_().m_82549_(this.getPunchDirection(player).m_82490_((double)clampedTime / 5.0)));
                        player.m_6001_(this.getPunchDirection((ServerPlayer)player).f_82479_ * 0.05, 0.0, this.getPunchDirection((ServerPlayer)player).f_82481_ * 0.05);
                        player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
                        pStack.m_41784_().m_128379_(PUNCHING, false);
                    }
                }
                ++this.tickCount;
                if (this.tickCount > 20) {
                    pStack.m_41784_().m_128379_(PUNCHING, false);
                    this.tickCount = 0;
                }
            }
        }
    }

    public Vec3 getPunchDirection(ServerPlayer player) {
        float yaw = player.m_146908_();
        double radians = Math.toRadians(yaw);
        float horizontalMovementX = (float)(-Math.sin(radians));
        float horizontalMovementZ = (float)Math.cos(radians);
        Vec3 punchDirection = new Vec3((double)horizontalMovementX, 0.0, (double)horizontalMovementZ);
        return punchDirection;
    }
}

