/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.generic;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.goo.brutality.config.BrutalityCommonConfig;
import net.goo.brutality.event.forge.DelayedTaskScheduler;
import net.goo.brutality.item.base.BrutalityGenericItem;
import net.goo.brutality.network.ClientboundSyncCapabilitiesPacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.EnchantmentHelper;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class CreaseOfCreation
extends BrutalityGenericItem {
    private static final Set<Enchantment> ALLOWED_ENCHANTMENTS = Set.of(Enchantments.f_44980_);

    public CreaseOfCreation(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public int getMaxDamage(ItemStack stack) {
        return 6000;
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41663_(Enchantments.f_44980_, 4);
        return stack;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.restrictEnchants(book, ALLOWED_ENCHANTMENTS);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return ALLOWED_ENCHANTMENTS.contains(enchantment);
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            pPlayer.m_6672_(pUsedHand);
            ItemStack stack = pPlayer.m_21120_(pUsedHand);
            List<Entity> targets = ModUtils.getEntitiesInRay(Entity.class, (LivingEntity)pPlayer, 30.0f, ClipContext.Fluid.NONE, ClipContext.Block.OUTLINE, 1.0f, entity -> entity != pPlayer, 10, null).entityList();
            Entity target = targets.isEmpty() ? null : targets.get(0);
            this.triggerAnim((Entity)pPlayer, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller_2", "use");
            if (target != null) {
                LivingEntity livingEntity;
                Player player;
                if (target instanceof Player && (player = (Player)target).m_21055_((Item)this)) {
                    return InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pUsedHand));
                }
                if (target instanceof LivingEntity && (livingEntity = (LivingEntity)target).m_21233_() > (float)((Integer)BrutalityCommonConfig.CREASE_OF_CREATION_THRESHOLD.get()).intValue()) {
                    return InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pUsedHand));
                }
                stack.m_41784_().m_128405_("target", target.m_19879_());
            }
        }
        return InteractionResultHolder.m_19098_((Object)pPlayer.m_21120_(pUsedHand));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", state -> state.setAndContinue(RawAnimation.begin().thenPlay("idle")))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller_2", state -> null).triggerableAnim("use", RawAnimation.begin().thenPlay("use"))});
    }

    public static void handleCreaseOfCreation(Player player) {
        player.m_21205_().m_41784_().m_128473_("target");
        player.m_21206_().m_41784_().m_128473_("target");
        InteractionHand[] interactionHandArray = player.m_9236_();
        if (!(interactionHandArray instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)interactionHandArray;
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.m_21120_(hand);
            Item item = stack.m_41720_();
            if (!(item instanceof CreaseOfCreation)) continue;
            CreaseOfCreation item2 = (CreaseOfCreation)item;
            long geoId = GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel);
            item2.stopTriggeredAnim((Entity)player, geoId, "controller_2", "use");
        }
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)item, (ServerLevel)serverLevel), "controller_2", "use");
            int targetId = item.m_41784_().m_128451_("target");
            Entity target = serverLevel.m_6815_(targetId);
            if (target != null) {
                target.getCapability(BrutalityCapabilities.ENTITY_SHOULD_ROTATE_CAP).ifPresent(cap -> {
                    cap.setShouldRotate(false);
                    PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(targetId, target));
                });
            }
            item.m_41784_().m_128473_("target");
        }
        return true;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            int targetId = pStack.m_41784_().m_128451_("target");
            Entity target = pLevel.m_6815_(targetId);
            pStack.m_41784_().m_128473_("target");
            this.stopTriggeredAnim((Entity)pLivingEntity, GeoItem.getOrAssignId((ItemStack)pStack, (ServerLevel)serverLevel), "controller_2", "use");
            if (target != null) {
                DelayedTaskScheduler.queueServerWork((Level)serverLevel, 30, () -> target.getCapability(BrutalityCapabilities.ENTITY_SHOULD_ROTATE_CAP).ifPresent(cap -> {
                    cap.setShouldRotate(false);
                    PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(targetId, target));
                }));
                if (!pLivingEntity.m_6144_()) {
                    return;
                }
                Vec3 lookAng = pLivingEntity.m_20154_().m_82490_(2.0);
                target.m_5997_(lookAng.f_82479_, lookAng.f_82480_, lookAng.f_82481_);
                if (target instanceof ServerPlayer) {
                    ServerPlayer playerTarget = (ServerPlayer)target;
                    playerTarget.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)playerTarget));
                }
                if (pLivingEntity instanceof Player) {
                    pLevel.m_247517_(null, pLivingEntity.m_20097_(), (SoundEvent)BrutalityModSounds.BASS_BOOM.get(), SoundSource.AMBIENT);
                }
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int remainingUseDuration) {
        if (!(player instanceof Player)) {
            return;
        }
        if (level.m_5776_()) {
            return;
        }
        int targetId = stack.m_41784_().m_128451_("target");
        Entity target = level.m_6815_(targetId);
        if (target == null) {
            return;
        }
        target.getCapability(BrutalityCapabilities.ENTITY_SHOULD_ROTATE_CAP).ifPresent(cap -> {
            if (!cap.isShouldRotate()) {
                cap.setShouldRotate(true);
                PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(targetId, target));
            }
        });
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 holdPos = player.m_146892_().m_82549_(lookVec.m_82490_(7.0));
        Vec3 direction = holdPos.m_82492_(target.m_20182_().f_82479_, target.m_20182_().f_82480_ + (double)(target.m_20206_() / 2.0f), target.m_20182_().f_82481_);
        double distance = direction.m_82553_();
        float normalized = (float)(Math.min(distance, 25.0) / 25.0);
        Vec3 force = direction.m_82541_().m_82490_((double)(normalized * 5.0f));
        Vec3 currentMotion = target.m_20184_();
        float lerpFactor = 0.5f;
        Vec3 newMotion = new Vec3(Mth.m_14139_((double)lerpFactor, (double)currentMotion.f_82479_, (double)force.f_82479_), Mth.m_14139_((double)lerpFactor, (double)currentMotion.f_82480_, (double)force.f_82480_), Mth.m_14139_((double)lerpFactor, (double)currentMotion.f_82481_, (double)force.f_82481_));
        target.f_19812_ = true;
        target.m_20256_(newMotion);
        stack.m_41622_(1, player, entity -> entity.m_21166_(Objects.requireNonNull(stack.getEquipmentSlot())));
        if (target instanceof LivingEntity) {
            if ((target.f_19862_ || target.f_19863_) && target.m_20184_().m_82556_() > 0.25) {
                target.m_6469_(player.m_269291_().m_269515_(), (float)target.m_20184_().m_82556_() * 5.0f);
            }
            if (target instanceof ServerPlayer) {
                ServerPlayer playerTarget = (ServerPlayer)target;
                playerTarget.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)playerTarget));
            }
        }
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pLevel instanceof ServerLevel && !pIsSelected && pStack.m_41784_().m_128441_("target")) {
            int targetId = pStack.m_41784_().m_128451_("target");
            pStack.m_41784_().m_128473_("target");
            Entity target = pLevel.m_6815_(targetId);
            if (target == null) {
                return;
            }
            DelayedTaskScheduler.queueServerWork(pLevel, 30, () -> target.getCapability(BrutalityCapabilities.ENTITY_SHOULD_ROTATE_CAP).ifPresent(cap -> {
                cap.setShouldRotate(false);
                PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(targetId, target));
            }));
        }
    }
}

