/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.bow;

import java.util.List;
import net.goo.brutality.item.base.BrutalityBowItem;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

@Mod.EventBusSubscriber(modid="brutality")
public class Providence
extends BrutalityBowItem {
    public Providence(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public int getMaxDamage(ItemStack stack) {
        return 1000;
    }

    @Override
    protected boolean requiresArrows() {
        return false;
    }

    @Override
    protected int getFullDrawTicks() {
        return 4;
    }

    @Override
    protected float getPowerMultiplier() {
        return 3.5f;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", state -> state.setAndContinue(RawAnimation.begin().thenLoop("idle"))).triggerableAnim("draw", RawAnimation.begin().thenPlayAndHold("draw")).triggerableAnim("release", RawAnimation.begin().thenPlay("release"))});
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)item, (ServerLevel)serverLevel), "controller", "release");
        }
        return super.onDroppedByPlayer(item, player);
    }

    public void m_6883_(@NotNull ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!pIsSelected && pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            this.triggerAnim(pEntity, GeoItem.getOrAssignId((ItemStack)pStack, (ServerLevel)serverLevel), "controller", "release");
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack bowStack = player.m_21120_(hand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)bowStack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)true);
            if (ret != null) {
                return ret;
            }
            if (level.m_46461_() && level.m_45527_(player.m_20183_().m_7494_())) {
                player.m_6672_(hand);
                this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)bowStack, (ServerLevel)serverLevel), "controller", "draw");
                return InteractionResultHolder.m_19096_((Object)bowStack);
            }
        }
        return InteractionResultHolder.m_19100_((Object)bowStack);
    }

    @Override
    protected SoundEvent getShootSound() {
        return (SoundEvent)BrutalityModSounds.WINGS_FLAP.get();
    }

    @Override
    protected EntityType<? extends AbstractArrow> getArrowEntity() {
        return (EntityType)BrutalityModEntities.LIGHT_ARROW.get();
    }

    @Override
    protected void onFullDraw(Player player, Level level) {
        List nearbyEntities = level.m_45971_(LivingEntity.class, TargetingConditions.f_26872_, null, player.m_20191_().m_82400_(3.0));
        level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(3.0), e -> {
            if (e instanceof Mob) {
                Mob mob = (Mob)e;
                return mob.m_5448_() != player || mob.m_7307_((Entity)player);
            }
            return true;
        });
        for (LivingEntity entity : nearbyEntities) {
            entity.m_147207_(new MobEffectInstance(MobEffects.f_19601_, 1, 0), (Entity)entity);
        }
    }

    @Override
    public void m_5551_(@NotNull ItemStack bowStack, @NotNull Level level, @NotNull LivingEntity shooter, int timeLeft) {
        super.m_5551_(bowStack, level, shooter, timeLeft);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim((Entity)shooter, GeoItem.getOrAssignId((ItemStack)bowStack, (ServerLevel)serverLevel), "controller", "release");
        }
    }
}

