/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.axe;

import java.util.List;
import net.goo.brutality.client.ClientAccess;
import net.goo.brutality.config.BrutalityCommonConfig;
import net.goo.brutality.item.base.BrutalityAxeItem;
import net.goo.brutality.registry.BrutalityDamageTypes;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.phys.OrientedBoundingBox;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Deathsaw
extends BrutalityAxeItem {
    public static Vec3 hitbox = new Vec3(0.125, 1.0, 3.0);

    public Deathsaw(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        ModUtils.setTextureIdx(stack, 1);
        pPlayer.m_6672_(pUsedHand);
        ClientAccess.startDeathsawSound(pPlayer);
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            OrientedBoundingBox.TargetResult<LivingEntity> targets = OrientedBoundingBox.findAttackTargetResult(player, LivingEntity.class, hitbox, 1.0);
            targets.entities.forEach(e -> e.m_6469_(BrutalityDamageTypes.deathsaw((Entity)player), (float)((Integer)BrutalityCommonConfig.DEATHSAW_TICK_DAMAGE.get()).intValue()));
            Direction lookDir = pLivingEntity.m_6350_();
            BlockPos pos = pLivingEntity.m_20183_().m_5484_(lookDir, 1);
            BlockState blockState = pLevel.m_8055_(pos);
            if (!blockState.m_60795_() && pLivingEntity.m_146909_() < -80.0f && pLivingEntity.f_19862_) {
                Vec3 deltaMovement = pLivingEntity.m_20184_();
                deltaMovement = new Vec3(deltaMovement.f_82479_, 0.2 * (Double)BrutalityCommonConfig.DEATHSAW_WALL_CLIMB_SPEED.get(), deltaMovement.f_82481_);
                pLivingEntity.m_20256_(deltaMovement);
            }
        }
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        ModUtils.removeTextureIdx(item);
        return super.onDroppedByPlayer(item, player);
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        ModUtils.removeTextureIdx(pStack);
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            player.m_36335_().m_41524_(pStack.m_41720_(), 10);
        }
        ClientAccess.stopDeathsawSound(pLivingEntity);
        super.m_5551_(pStack, pLevel, pLivingEntity, pTimeCharged);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pTarget.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.PULVERIZED.get(), 5, 1));
        return super.m_7579_(pStack, pTarget, pAttacker);
    }
}

