/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.necklace;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.SlotContext;

public class BloodHowlPendant
extends BrutalityCurioItem {
    UUID BLOOD_HOWL_RAGE_GAIN_UUID = UUID.fromString("9f300d11-6844-4a87-8350-eb0cee580300");
    private static final Object2BooleanOpenHashMap<UUID> WAS_ACTIVE_MAP = new Object2BooleanOpenHashMap();

    public BloodHowlPendant(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.NECKLACE;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        if (slotContext.entity() != null && !(livingEntity = slotContext.entity()).m_9236_().m_5776_() && livingEntity.f_19797_ % 10 == 0) {
            AttributeInstance rageGain = livingEntity.m_21051_((Attribute)ModAttributes.RAGE_GAIN_MULTIPLIER.get());
            boolean active = livingEntity.m_21223_() / livingEntity.m_21233_() < 0.5f;
            UUID uuid = livingEntity.m_20148_();
            boolean wasActive = WAS_ACTIVE_MAP.getOrDefault((Object)uuid, false);
            if (rageGain != null && wasActive != active) {
                WAS_ACTIVE_MAP.put((Object)uuid, active);
                rageGain.m_22120_(this.BLOOD_HOWL_RAGE_GAIN_UUID);
                if (active) {
                    rageGain.m_22118_(new AttributeModifier(this.BLOOD_HOWL_RAGE_GAIN_UUID, "Rage Gain Buff", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
                }
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (slotContext.entity() != null) {
            WAS_ACTIVE_MAP.removeBoolean((Object)slotContext.entity().m_20148_());
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (slotContext.entity() != null && slotContext.entity().m_21223_() / slotContext.entity().m_21233_() < 0.5f) {
            ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
            builder.put((Object)((Attribute)ModAttributes.RAGE_GAIN_MULTIPLIER.get()), (Object)new AttributeModifier(this.BLOOD_HOWL_RAGE_GAIN_UUID, "Rage Gain Buff", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

