/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.hands;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class Handcuffs
extends BrutalityCurioItem {
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOUR = new DefaultDispenseItemBehavior(){

        @NotNull
        protected ItemStack m_7498_(BlockSource pSource, ItemStack pStack) {
            return Handcuffs.equipToFirstEmptySlot(pSource, pStack) ? pStack : super.m_7498_(pSource, pStack);
        }
    };

    public Handcuffs(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOUR);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.HANDS;
    }

    public static boolean equipToFirstEmptySlot(BlockSource source, ItemStack stack) {
        BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
        List list = source.m_7727_().m_6443_(LivingEntity.class, new AABB(pos), EntitySelector.f_20408_);
        if (list.isEmpty()) {
            return false;
        }
        LivingEntity target = (LivingEntity)list.get(0);
        return CuriosApi.getCuriosInventory((LivingEntity)target).map(handler -> {
            Optional curioOpt = CuriosApi.getCurio((ItemStack)stack).resolve();
            if (curioOpt.isEmpty()) {
                return false;
            }
            ICurio curio = (ICurio)curioOpt.get();
            Set validSlots = CuriosApi.getItemStackSlots((ItemStack)stack, (LivingEntity)target).keySet();
            for (String id : validSlots) {
                ICurioStacksHandler curioHandler = (ICurioStacksHandler)handler.getCurios().get(id);
                if (curioHandler == null) continue;
                IDynamicStackHandler stacks = curioHandler.getStacks();
                NonNullList renders = curioHandler.getRenders();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    SlotContext ctx;
                    if (!stacks.getStackInSlot(i).m_41619_() || !curio.canEquip(ctx = new SlotContext(id, target, i, false, renders.size() > i && (Boolean)renders.get(i) != false))) continue;
                    ItemStack toEquip = stack.m_41620_(1);
                    stacks.setStackInSlot(i, toEquip);
                    curio.onEquipFromUse(ctx);
                    return true;
                }
            }
            return false;
        }).orElse(false);
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41663_(Enchantments.f_44975_, 1);
        return stack;
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        if (slotContext.entity() != null) {
            LivingEntity livingEntity = slotContext.entity();
            ICuriosItemHandler handler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).orElse(null);
            return !handler.isEquipped((Item)this);
        }
        return super.canEquip(slotContext, stack);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (slotContext.entity() != null) {
            LivingEntity livingEntity = slotContext.entity();
            if (livingEntity.f_19797_ % 20 == 0) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 21, 1, false, false, true));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 21, 2, false, false, true));
            }
        }
    }
}

