/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.charm;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.SlotContext;

public class TargetCube
extends BrutalityCurioItem {
    UUID TARGET_CUBE_CRIT_CHANCE_UUID = UUID.fromString("fd88bba5-e451-4ed7-aa8a-b3f19e14a5ee");
    private static final Object2FloatOpenHashMap<UUID> OLD_BONUS_MAP = new Object2FloatOpenHashMap();

    public TargetCube(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.CHARM;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        if (slotContext.entity() != null && !(livingEntity = slotContext.entity()).m_9236_().m_5776_() && livingEntity.f_19797_ % 10 == 0) {
            AttributeInstance attackDamage = livingEntity.m_21051_((Attribute)ModAttributes.CRITICAL_STRIKE_CHANCE.get());
            float newBonus = (float)(livingEntity.m_21133_(Attributes.f_22286_) * (double)0.1f);
            UUID uuid = livingEntity.m_20148_();
            float oldBonus = OLD_BONUS_MAP.getOrDefault((Object)uuid, 0.0f);
            if (attackDamage != null && (double)Math.abs(oldBonus - newBonus) > 1.0E-4) {
                OLD_BONUS_MAP.put((Object)uuid, newBonus);
                attackDamage.m_22120_(this.TARGET_CUBE_CRIT_CHANCE_UUID);
                attackDamage.m_22118_(new AttributeModifier(this.TARGET_CUBE_CRIT_CHANCE_UUID, "Crit Chance Bonus", (double)newBonus, AttributeModifier.Operation.MULTIPLY_BASE));
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (slotContext.entity() != null) {
            OLD_BONUS_MAP.removeFloat((Object)slotContext.entity().m_20148_());
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (slotContext.entity() != null) {
            ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
            builder.put((Object)((Attribute)ModAttributes.CRITICAL_STRIKE_CHANCE.get()), (Object)new AttributeModifier(this.TARGET_CUBE_CRIT_CHANCE_UUID, "Crit Chance Buff", slotContext.entity().m_21133_(Attributes.f_22286_) * (double)0.1f, AttributeModifier.Operation.MULTIPLY_BASE));
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

