/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.charm;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.network.ClientboundSyncCapabilitiesPacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.SlotContext;

public class SpiteShard
extends BrutalityCurioItem {
    UUID SPITE_SHARD_MAX_RAGE_UUID = UUID.fromString("e2bc1e9c-5cde-4de1-8e3a-60d97d6673d8");

    public SpiteShard(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.CHARM;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (slotContext.entity() != null) {
            ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
            builder.put((Object)((Attribute)ModAttributes.MAX_RAGE.get()), (Object)new AttributeModifier(this.SPITE_SHARD_MAX_RAGE_UUID, "Max Rage Buff", 50.0, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        List aggroEntities;
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_9236_() instanceof ServerLevel && player.f_19797_ % 20 == 0 && !(aggroEntities = player.m_9236_().m_45971_(Mob.class, TargetingConditions.m_148352_().m_26888_(e -> {
            Mob mob;
            return e instanceof Mob && (mob = (Mob)e).m_5448_() == player;
        }), (LivingEntity)player, player.m_20191_().m_82400_(5.0))).isEmpty()) {
            player.getCapability(BrutalityCapabilities.PLAYER_RAGE_CAP).ifPresent(cap -> {
                cap.incrementRage((float)aggroEntities.size() / 5.0f);
                PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(player.m_19879_(), (Entity)player));
            });
        }
    }
}

