/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.charm;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.magic.SpellCastingHandler;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.SlotContext;

public class ScribesIndex
extends BrutalityCurioItem {
    private static final Object2BooleanOpenHashMap<UUID> MANA_STATE_MAP = new Object2BooleanOpenHashMap();
    UUID SCRIBES_INDEX_SPELL_DAMAGE_UUID = UUID.fromString("8cec320c-659a-4221-b8e1-2e73e734f831");

    public ScribesIndex(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.CHARM;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().m_5776_() || player.f_19797_ % 10 != 0) {
            return;
        }
        AttributeInstance spellDamage = player.m_21051_((Attribute)ModAttributes.SPELL_DAMAGE.get());
        if (spellDamage == null) {
            return;
        }
        boolean isMaxMana = SpellCastingHandler.getManaHandler(player).map(cap -> cap.isMaxMana(player)).orElse(false);
        UUID uuid = player.m_20148_();
        boolean wasMaxMana = MANA_STATE_MAP.getOrDefault((Object)uuid, false);
        if (wasMaxMana == isMaxMana) {
            return;
        }
        MANA_STATE_MAP.put((Object)uuid, isMaxMana);
        spellDamage.m_22120_(this.SCRIBES_INDEX_SPELL_DAMAGE_UUID);
        float bonus = isMaxMana ? 0.25f : -0.1f;
        spellDamage.m_22118_(new AttributeModifier(this.SCRIBES_INDEX_SPELL_DAMAGE_UUID, "Scribes Index Bonus", (double)bonus, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (slotContext.entity() != null) {
            MANA_STATE_MAP.removeBoolean((Object)slotContext.entity().m_20148_());
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
            boolean isMaxMana = SpellCastingHandler.getManaHandler(player).map(cap -> cap.isMaxMana(player)).orElse(false);
            float newBonus = isMaxMana ? 0.25f : -0.1f;
            builder.put((Object)((Attribute)ModAttributes.SPELL_DAMAGE.get()), (Object)new AttributeModifier(this.SCRIBES_INDEX_SPELL_DAMAGE_UUID, "Spell Damage Buff", (double)newBonus, AttributeModifier.Operation.MULTIPLY_TOTAL));
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

