/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.charm;

import java.util.List;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class PortableMiningRig
extends BrutalityCurioItem {
    public static final String END_COIN = "endCoin";
    public static final String NETHER_COIN = "netherCoin";

    public PortableMiningRig(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (slotContext.entity() != null) {
            LivingEntity livingEntity = slotContext.entity();
            Level level = livingEntity.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            if (livingEntity.f_19797_ % 20 != 0) {
                return;
            }
            CuriosApi.getCuriosInventory((LivingEntity)livingEntity).ifPresent(handler -> handler.findFirstCurio((Item)BrutalityModItems.CRYPTO_WALLET_CHARM.get()).ifPresent(slotResult -> {
                float adjustedReward;
                float logFraction;
                float power;
                float cap;
                float baseReward;
                ItemStack cryptoWalletStack = slotResult.stack();
                RandomSource random = serverLevel.m_213780_();
                if (random.m_216332_(0, 100) < 3) {
                    baseReward = Mth.m_216267_((RandomSource)random, (float)0.0f, (float)0.005f);
                    cap = 25.0f;
                    power = 2.0f;
                    float currentEndCoins = cryptoWalletStack.m_41784_().m_128457_(END_COIN);
                    logFraction = (float)(Math.log(currentEndCoins + 1.0f) / Math.log(cap + 1.0f));
                    adjustedReward = baseReward * (1.0f - (float)Math.pow(logFraction, power));
                    cryptoWalletStack.m_41784_().m_128350_(END_COIN, currentEndCoins + adjustedReward);
                }
                if (random.m_216332_(0, 100) < 2) {
                    baseReward = Mth.m_216267_((RandomSource)random, (float)0.0f, (float)0.001f);
                    cap = 1.5f;
                    power = 2.0f;
                    float currentNetherCoins = cryptoWalletStack.m_41784_().m_128457_(NETHER_COIN);
                    logFraction = (float)(Math.log(currentNetherCoins + 1.0f) / Math.log(cap + 1.0f));
                    adjustedReward = baseReward * (1.0f - (float)Math.pow(logFraction, power));
                    cryptoWalletStack.m_41784_().m_128350_(NETHER_COIN, currentNetherCoins + adjustedReward);
                }
            }));
        }
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.CHARM;
    }
}

