/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.charm;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.entity.projectile.generic.PiEntity;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class Pi
extends BrutalityCurioItem {
    boolean canSpawn = false;
    float piMult = 0.0314f;
    float pi = 3.14f;
    UUID PI_CHARM_MS_UUID = UUID.fromString("5889431d-06af-4bef-b3c2-7d1cf5abda3c");
    UUID PI_CHARM_AS_UUID = UUID.fromString("d24bf9bb-e6d1-4b34-8758-5b294cc7db6d");
    UUID PI_CHARM_AD_UUID = UUID.fromString("a1c85971-cded-4c2a-adcf-e5b3ab6b9211");

    public Pi(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.CHARM;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosInventory((LivingEntity)slotContext.entity()).map(handler -> handler.findFirstCurio((Item)BrutalityModItems.SCIENTIFIC_CALCULATOR.get()).isPresent()).orElse(false);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                this.canSpawn = handler.isEquipped((Item)BrutalityModItems.SCIENTIFIC_CALCULATOR.get());
            });
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity owner = slotContext.entity();
        if (!owner.m_9236_().m_5776_() && this.canSpawn) {
            for (int i = 0; i < 3; ++i) {
                int angleOffset = (int)Math.toRadians(120 * i);
                PiEntity pi = new PiEntity((EntityType<? extends ThrowableProjectile>)((EntityType)BrutalityModEntities.PI_ENTITY.get()), owner.m_9236_(), angleOffset);
                pi.m_146884_(owner.m_20318_(1.0f));
                pi.m_5602_((Entity)owner);
                owner.m_9236_().m_7967_((Entity)pi);
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (slotContext.entity() != null) {
            ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
            builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(this.PI_CHARM_MS_UUID, "MS Buff", (double)this.piMult, AttributeModifier.Operation.MULTIPLY_TOTAL));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(this.PI_CHARM_AS_UUID, "AS Buff", (double)this.piMult, AttributeModifier.Operation.MULTIPLY_TOTAL));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(this.PI_CHARM_AD_UUID, "AD Buff", (double)this.pi, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity owner = slotContext.entity();
        for (PiEntity piEntity : owner.m_9236_().m_45976_(PiEntity.class, owner.m_20191_().m_82400_(10.0))) {
            piEntity.m_146870_();
        }
    }
}

