/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.anklet;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.base.BrutalityAnkletItem;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.SlotContext;

public class AnkletOfTheImprisoned
extends BrutalityAnkletItem {
    UUID AOTI_CRIT_CHANCE_UUID = UUID.fromString("0ea9e820-3aee-4977-8b7d-147cba7af3f6");
    UUID AOTI_CRIT_DAMAGE_UUID = UUID.fromString("30376e02-d415-4f55-9ea0-8f8339f83cc6");
    private static final Object2FloatOpenHashMap<UUID> OLD_HEALTH_MAP = new Object2FloatOpenHashMap();

    public AnkletOfTheImprisoned(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (slotContext.entity() != null) {
            LivingEntity livingEntity = slotContext.entity();
            if (!livingEntity.m_9236_().m_5776_() && livingEntity.f_19797_ % 10 == 0) {
                AttributeInstance critChance = livingEntity.m_21051_((Attribute)ModAttributes.CRITICAL_STRIKE_CHANCE.get());
                AttributeInstance critDamage = livingEntity.m_21051_((Attribute)ModAttributes.CRITICAL_STRIKE_DAMAGE.get());
                UUID uuid = livingEntity.m_20148_();
                if (critChance != null & critDamage != null) {
                    float newHealth = livingEntity.m_21223_();
                    float oldHealth = OLD_HEALTH_MAP.getOrDefault((Object)uuid, 0.0f);
                    if ((double)Math.abs(oldHealth - newHealth) > 1.0E-4) {
                        float missingHealth = livingEntity.m_21233_() - newHealth;
                        float newBonus = missingHealth * 0.075f;
                        OLD_HEALTH_MAP.put((Object)uuid, newHealth);
                        critDamage.m_22120_(this.AOTI_CRIT_DAMAGE_UUID);
                        critChance.m_22120_(this.AOTI_CRIT_CHANCE_UUID);
                        critDamage.m_22118_(new AttributeModifier(this.AOTI_CRIT_DAMAGE_UUID, "Crit Damage Buff", (double)newBonus, AttributeModifier.Operation.MULTIPLY_BASE));
                        critChance.m_22118_(new AttributeModifier(this.AOTI_CRIT_CHANCE_UUID, "Crit Chance Buff", (double)newBonus, AttributeModifier.Operation.MULTIPLY_BASE));
                    }
                }
            }
            if (livingEntity.f_19797_ % 20 == 0) {
                slotContext.entity().m_6469_(slotContext.entity().m_269291_().m_269264_(), 1.0f);
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (slotContext.entity() != null) {
            OLD_HEALTH_MAP.removeFloat((Object)slotContext.entity().m_20148_());
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (slotContext.entity() != null) {
            ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
            LivingEntity livingEntity = slotContext.entity();
            float missingHealth = livingEntity.m_21233_() - livingEntity.m_21223_();
            float newBonus = missingHealth * 0.075f;
            builder.put((Object)((Attribute)ModAttributes.CRITICAL_STRIKE_CHANCE.get()), (Object)new AttributeModifier(this.AOTI_CRIT_CHANCE_UUID, "Crit Chance Buff", (double)newBonus, AttributeModifier.Operation.MULTIPLY_BASE));
            builder.put((Object)((Attribute)ModAttributes.CRITICAL_STRIKE_DAMAGE.get()), (Object)new AttributeModifier(this.AOTI_CRIT_DAMAGE_UUID, "Crit Damage Buff", (double)newBonus, AttributeModifier.Operation.MULTIPLY_BASE));
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

