/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.base;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.util.ModResources;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public interface BrutalityGeoItem
extends GeoItem,
ModResources {
    public static final UUID BASE_STUN_CHANCE_UUID = UUID.fromString("6d3d3787-e06f-4111-b03f-aed7c9317416");
    public static final Map<BrutalityTooltipHelper.ItemDescriptionComponents, KeyMapping> keyMappings = new HashMap<BrutalityTooltipHelper.ItemDescriptionComponents, KeyMapping>();

    default public String getRegistryName() {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((Item)this))).m_135815_().toLowerCase(Locale.ROOT);
    }

    public BrutalityCategories.AttackType getAttackType();

    public BrutalityCategories category();

    default public String model(@Nullable ItemStack stack) {
        return null;
    }

    default public String texture(@Nullable ItemStack stack) {
        return null;
    }

    default public String animation(@Nullable ItemStack stack) {
        return null;
    }

    default public String getCategoryAsString() {
        return this.category().toString().toLowerCase(Locale.ROOT);
    }

    default public float shadowSize() {
        return 0.15f;
    }

    public GeoAnimatable cacheItem();

    default public Component brutalityNameHandler(ItemStack stack) {
        Rarity rarity = stack.m_41791_();
        String identifier = this.getRegistryName();
        if (rarity.equals((Object)Rarity.UNCOMMON) || rarity.equals((Object)Rarity.COMMON) || rarity.equals((Object)Rarity.RARE) || rarity.equals((Object)Rarity.EPIC)) {
            return Component.m_237115_((String)("item.brutality." + identifier));
        }
        return BrutalityTooltipHelper.getRarityName("item.brutality." + identifier, rarity);
    }

    default public void brutalityTooltipHandler(ItemStack stack, List<Component> pTooltipComponents, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents, Rarity rarity) {
        String identifier = this.getRegistryName();
        if (!ModList.get().isLoaded("obscuria_tooltips")) {
            pTooltipComponents.add((Component)Component.m_237115_((String)("rarity." + rarity.toString().toLowerCase(Locale.ROOT) + ".name")).m_130948_(Style.f_131099_.m_131150_(ModResources.RARITY_FONT)));
        }
        if (descriptionComponents.contains((Object)BrutalityTooltipHelper.ItemDescriptionComponents.LORE)) {
            pTooltipComponents.add((Component)Component.m_237115_((String)("item.brutality." + identifier + ".lore")));
        }
        for (BrutalityTooltipHelper.ItemDescriptionComponent descriptionComponent : descriptionComponents) {
            boolean isLore = descriptionComponent.type().equals((Object)BrutalityTooltipHelper.ItemDescriptionComponents.LORE);
            String componentLower = descriptionComponent.type().toString().toLowerCase(Locale.ROOT);
            if (!isLore) {
                KeyMapping key;
                pTooltipComponents.add((Component)Component.m_237115_((String)("brutality.description.type." + componentLower)));
                for (int i = 1; i <= descriptionComponent.lines(); ++i) {
                    pTooltipComponents.add((Component)Component.m_237115_((String)("item.brutality." + identifier + "." + componentLower + "." + i)));
                }
                if (descriptionComponent.cooldownTicks() != null) {
                    int totalSecs = (int)((float)descriptionComponent.cooldownTicks().intValue() / 20.0f);
                    int hours = (int)((float)totalSecs / 3600.0f);
                    int minutes = (int)((float)(totalSecs % 3600) / 60.0f);
                    int seconds = totalSecs % 60;
                    StringBuilder formatted = new StringBuilder();
                    boolean first = true;
                    if (hours > 0) {
                        formatted.append(hours).append(" hour");
                        first = false;
                    }
                    if (minutes > 0) {
                        if (!first) {
                            formatted.append(" ");
                        }
                        formatted.append(minutes).append(" minute");
                        first = false;
                    }
                    if (seconds > 0 || hours == 0 && minutes == 0) {
                        if (!first) {
                            formatted.append(" ");
                        }
                        formatted.append(seconds).append(" second");
                    }
                    MutableComponent component = Component.m_237113_((String)(" -" + formatted + " ")).m_7220_((Component)Component.m_237115_((String)"message.brutality.cooldown"));
                    pTooltipComponents.add((Component)component.m_130940_(ChatFormatting.DARK_AQUA));
                }
                if ((key = keyMappings.get((Object)descriptionComponent.type())) != null) {
                    MutableComponent component = Component.m_237113_((String)"(").m_7220_((Component)Component.m_237115_((String)"key.brutality.current_keybind")).m_130946_(": ").m_7220_(key.getKey().m_84875_()).m_130946_(")");
                    pTooltipComponents.add((Component)component.m_130940_(ChatFormatting.GRAY));
                }
            } else {
                for (int i = 1; i <= descriptionComponent.lines(); ++i) {
                    pTooltipComponents.add((Component)Component.m_237115_((String)("item.brutality." + identifier + "." + componentLower + "." + i)).m_130940_(ChatFormatting.BLUE));
                }
            }
            if (descriptionComponent.equals(descriptionComponents.get(descriptionComponents.size() - 1))) continue;
            pTooltipComponents.add((Component)Component.m_237119_());
        }
        if (stack.m_41793_() && (6 & ItemStack.TooltipPart.ENCHANTMENTS.m_41809_()) == 0) {
            pTooltipComponents.add((Component)Component.m_237119_());
        }
    }

    default public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(RawAnimation.begin().thenLoop("idle")))});
    }

    default public void onDeselected(Player player) {
    }

    default public void onDeselected(Player player, ItemStack stack) {
        this.onDeselected(player);
    }
}

