/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.base;

import java.util.List;
import java.util.function.Consumer;
import net.goo.brutality.event.mod.client.BrutalityModItemRenderManager;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityGeoItem;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;

public class BrutalityBowItem
extends BowItem
implements BrutalityGeoItem {
    public String identifier;
    public Rarity rarity;
    private final List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents;
    AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public BrutalityBowItem(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(new Item.Properties().m_41487_(1));
        this.rarity = rarity;
        this.descriptionComponents = descriptionComponents;
    }

    @Override
    public BrutalityCategories.AttackType getAttackType() {
        return BrutalityCategories.AttackType.NONE;
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack pStack) {
        return this.rarity;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack pStack) {
        return this.brutalityNameHandler(pStack);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        this.brutalityTooltipHandler(pStack, pTooltipComponents, this.descriptionComponents, this.rarity);
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    @Override
    public GeoAnimatable cacheItem() {
        return this;
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.ItemType.BOW;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected boolean requiresArrows() {
        return true;
    }

    protected float getArrowBaseDamage() {
        return 1.0f;
    }

    protected int getFullDrawTicks() {
        return 20;
    }

    protected float getPowerMultiplier() {
        return 3.0f;
    }

    public static float getPowerForTime(int pCharge, float fullDrawTicks) {
        float f = (float)pCharge / fullDrawTicks;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return BrutalityModItemRenderManager.createRenderer(BrutalityBowItem.this);
            }
        });
    }

    protected EntityType<? extends AbstractArrow> getArrowEntity() {
        return EntityType.f_20548_;
    }

    protected void onFullDraw(Player player, Level level) {
    }

    protected SoundEvent getShootSound() {
        return SoundEvents.f_11687_;
    }

    public void m_5551_(@NotNull ItemStack bowStack, @NotNull Level level, @NotNull LivingEntity shooter, int timeLeft) {
        if (shooter instanceof Player) {
            ArrowItem arrowItem;
            Item item;
            Player player = (Player)shooter;
            ItemStack arrowStack = player.m_6298_(bowStack);
            boolean infiniteArrows = player.m_150110_().f_35937_ || bowStack.getEnchantmentLevel(Enchantments.f_44952_) > 0 || (item = arrowStack.m_41720_()) instanceof ArrowItem && (arrowItem = (ArrowItem)item).isInfinite(arrowStack, bowStack, player) || !this.requiresArrows();
            int chargeTime = this.m_8105_(bowStack) - timeLeft;
            if ((chargeTime = ForgeEventFactory.onArrowLoose((ItemStack)bowStack, (Level)level, (Player)player, (int)chargeTime, (!arrowStack.m_41619_() || infiniteArrows ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!arrowStack.m_41619_() || infiniteArrows) {
                float drawPower;
                if (arrowStack.m_41619_()) {
                    arrowStack = new ItemStack((ItemLike)Items.f_42412_);
                }
                if ((drawPower = BrutalityBowItem.getPowerForTime(chargeTime, this.getFullDrawTicks())) >= 0.1f) {
                    AbstractArrow arrowEntity;
                    if (!level.f_46443_ && (arrowEntity = (AbstractArrow)this.getArrowEntity().m_20615_(level)) != null) {
                        int punchLevel;
                        int powerLevel;
                        arrowEntity.m_5602_((Entity)player);
                        arrowEntity.m_36781_((double)this.getArrowBaseDamage());
                        arrowEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, drawPower * this.getPowerMultiplier(), 0.0f);
                        if (drawPower == 1.0f) {
                            arrowEntity.m_36762_(true);
                            this.onFullDraw(player, level);
                        }
                        if ((powerLevel = bowStack.getEnchantmentLevel(Enchantments.f_44988_)) > 0) {
                            arrowEntity.m_36781_(arrowEntity.m_36789_() + ((double)powerLevel * 0.5 + 0.5));
                        }
                        if ((punchLevel = bowStack.getEnchantmentLevel(Enchantments.f_44989_)) > 0) {
                            arrowEntity.m_36735_(punchLevel);
                        }
                        if (bowStack.getEnchantmentLevel(Enchantments.f_44990_) > 0) {
                            arrowEntity.m_20254_(100);
                        }
                        bowStack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(player.m_7655_()));
                        if (infiniteArrows || player.m_150110_().f_35937_ && (arrowStack.m_150930_(Items.f_42737_) || arrowStack.m_150930_(Items.f_42738_))) {
                            arrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.m_7967_((Entity)arrowEntity);
                    }
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getShootSound(), SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 1.2f) + drawPower * 0.5f);
                    if (!infiniteArrows && !player.m_150110_().f_35937_) {
                        arrowStack.m_41774_(1);
                        if (arrowStack.m_41619_()) {
                            player.m_150109_().m_36057_(arrowStack);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }
}

