/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Locale;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.magic.SpellStorage;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RadialProgressBarRenderer {
    private static final double RADIUS = 48.0;

    public static void renderProgressBar(ItemStack tome, @NotNull GuiGraphics graphics, double x, double y, double z, float progress) {
        SpellStorage.SpellEntry spellEntry = SpellStorage.getCurrentSpellEntry(tome);
        if (spellEntry == null) {
            return;
        }
        IBrutalitySpell.MagicSchool school = spellEntry.spell().getSchool();
        String schoolStr = school.toString().toLowerCase(Locale.ROOT);
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("textures/gui/spells/" + schoolStr + "/spell_container/cast_ring.png")));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(x, y, z).m_7421_(0.5f, 0.5f).m_5752_();
        double end = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
        int pointCount = 180;
        for (float startPoint = 0.0f; startPoint <= 1.0f && !((double)startPoint >= end); startPoint += 1.0f / (float)pointCount) {
            double endPoint = Math.min((double)(startPoint + 1.0f / (float)pointCount), end);
            if (endPoint >= end) {
                RadialProgressBarRenderer.addVertex(buffer, x, y, z, end, 48.0);
                break;
            }
            RadialProgressBarRenderer.addVertex(buffer, x, y, z, endPoint, 48.0);
        }
        tesselator.m_85914_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
    }

    private static void addVertex(BufferBuilder buffer, double x, double y, double z, double point, double radius) {
        double angle = point * 2.0 * Math.PI + 1.5707963267948966;
        double vx = Math.cos(angle);
        double vy = -Math.sin(angle);
        buffer.m_5483_(x + vx * radius, y + vy * radius, z).m_7421_((float)(vx / 2.0 + 0.5), (float)(vy / 2.0 + 0.5)).m_5752_();
    }
}

