/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.event.mod.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.goo.brutality.client.renderers.item.BrutalityItemRenderer;
import net.goo.brutality.client.renderers.layers.BrutalityAutoAlphaLayer;
import net.goo.brutality.client.renderers.layers.BrutalityAutoEndPortalLayer;
import net.goo.brutality.client.renderers.layers.BrutalityAutoFullbrightLayer;
import net.goo.brutality.client.renderers.layers.BrutalityAutoFullbrightNoDepthLayer;
import net.goo.brutality.client.renderers.layers.BrutalityItemLayer;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.util.SealUtils;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.IItemDecorator;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

@Mod.EventBusSubscriber(modid="brutality", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class BrutalityModItemRenderManager {
    private static final Map<Item, List<Consumer<BrutalityItemRenderer<?>>>> LAYER_CONFIGURATIONS = new HashMap();

    @SubscribeEvent
    public static void registerItemDecorations(RegisterItemDecorationsEvent event) {
        ForgeRegistries.ITEMS.forEach(item -> event.register((ItemLike)item, (IItemDecorator)new SealUtils()));
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.FROSTMOURNE_SWORD.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.BIOMECH_REACTOR.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.UMBRAL_TOME.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoEndPortalLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.COSMIC_TOME.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.DARKIST_TOME.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.CELESTIA_TOME.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.BRIMWIELDER_TOME.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.VOID_TOME.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightNoDepthLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.ATOMIC_JUDGEMENT_HAMMER.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.PROVIDENCE.get(), renderer -> {
                renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightNoDepthLayer(renderer));
                renderer.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)renderer));
            });
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.ONYX_PHASESABER.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.TOPAZ_PHASESABER.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.SAPPHIRE_PHASESABER.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.RUBY_PHASESABER.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.CREASE_OF_CREATION.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.ATOMIC_JUDGEMENT_HAMMER.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.EVENT_HORIZON.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightNoDepthLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.DARKIN_SCYTHE.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.BLADE_OF_THE_RUINED_KING.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightNoDepthLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.BLADE_OF_THE_RUINED_KING.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightNoDepthLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.DOUBLE_DOWN.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoAlphaLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.DULL_KNIFE_DAGGER.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.SEVENTH_STAR.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoFullbrightNoDepthLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.VOID_KNIFE.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new BrutalityAutoEndPortalLayer(renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.GUNGNIR_TRIDENT.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)renderer)));
            BrutalityModItemRenderManager.registerItemLayers((Item)BrutalityModItems.THUNDERBOLT_TRIDENT.get(), renderer -> renderer.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)renderer)));
        });
    }

    public static <T extends Item> void registerItemLayers(@NotNull Item item, Consumer<BrutalityItemRenderer<T>> layerConfigurer) {
        LAYER_CONFIGURATIONS.put(item, List.of(layerConfigurer));
    }

    public static <T extends Item> BrutalityItemRenderer<T> createRenderer(T item) {
        BrutalityItemRenderer renderer = new BrutalityItemRenderer();
        renderer.addRenderLayer(new BrutalityItemLayer(renderer));
        List configurers = LAYER_CONFIGURATIONS.getOrDefault(item, new ArrayList());
        for (Consumer configurer : configurers) {
            configurer.accept(renderer);
        }
        return renderer;
    }
}

