/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.event.mod.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.goo.brutality.client.renderers.block.BrutalityBlockEntityWithoutLevelRenderer;
import net.goo.brutality.client.renderers.block.BrutalityGeoBlockRenderer;
import net.goo.brutality.client.renderers.block.FilingCabinetBlockEntityRenderer;
import net.goo.brutality.client.renderers.block.RotatableBlockRenderer;
import net.goo.brutality.client.renderers.layers.BrutalityBlockLayer;
import net.goo.brutality.registry.BrutalityModBlockEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="brutality", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BrutalityModBlockRenderManager {
    private static final Map<BlockEntity, List<Consumer<BrutalityGeoBlockRenderer<?>>>> LAYER_CONFIGURATIONS = new HashMap();

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)BrutalityModBlockEntities.WHITE_FILING_CABINET_BLOCK_ENTITY.get(), FilingCabinetBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BrutalityModBlockEntities.LIGHT_GRAY_FILING_CABINET_BLOCK_ENTITY.get(), FilingCabinetBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BrutalityModBlockEntities.GRAY_FILING_CABINET_BLOCK_ENTITY.get(), FilingCabinetBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BrutalityModBlockEntities.WATER_COOLER_BLOCK_ENTITY.get(), BrutalityGeoBlockRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BrutalityModBlockEntities.COFFEE_MACHINE_BLOCK_ENTITY.get(), BrutalityGeoBlockRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BrutalityModBlockEntities.SUPER_SNIFFER_FIGURE_BLOCK_ENTITY.get(), BrutalityGeoBlockRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BrutalityModBlockEntities.WET_FLOOR_SIGN_BLOCK_ENTITY.get(), RotatableBlockRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BrutalityModBlockEntities.LCD_MONITOR_BLOCK_ENTITY.get(), RotatableBlockRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BrutalityModBlockEntities.WHITE_OFFICE_CHAIR_BLOCK_ENTITY.get(), RotatableBlockRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BrutalityModBlockEntities.BLACK_OFFICE_CHAIR_BLOCK_ENTITY.get(), RotatableBlockRenderer::new);
    }

    public static IClientItemExtensions getDefaultExtensions() {
        return new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                Minecraft mc = Minecraft.m_91087_();
                return BrutalityBlockEntityWithoutLevelRenderer.getInstance(new BlockEntityRendererProvider.Context(mc.m_167982_(), mc.m_91289_(), mc.m_91291_(), mc.m_91290_(), mc.m_167973_(), mc.f_91062_));
            }
        };
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(FilingCabinetBlockEntityRenderer.FILING_CABINET_LAYER, FilingCabinetBlockEntityRenderer::createBodyLayer);
    }

    public static <T extends BlockEntity> void registerBlockEntityLayers(@NotNull BlockEntity blockEntity, Consumer<BrutalityGeoBlockRenderer<T>> layerConfigurer) {
        LAYER_CONFIGURATIONS.put(blockEntity, List.of(layerConfigurer));
    }

    public static <T extends BlockEntity> BrutalityGeoBlockRenderer<T> createRenderer(T block) {
        BrutalityGeoBlockRenderer renderer = new BrutalityGeoBlockRenderer();
        renderer.addRenderLayer(new BrutalityBlockLayer(renderer));
        List configurers = LAYER_CONFIGURATIONS.getOrDefault(block, new ArrayList());
        for (Consumer configurer : configurers) {
            configurer.accept(renderer);
        }
        return renderer;
    }
}

