/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.event.forge.client;

import java.util.stream.StreamSupport;
import net.goo.brutality.config.BrutalityClientConfig;
import net.goo.brutality.event.mod.client.Keybindings;
import net.goo.brutality.item.BrutalityArmorMaterials;
import net.goo.brutality.item.base.BrutalityThrowingItem;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.network.ServerboundActivateRagePacket;
import net.goo.brutality.network.ServerboundActiveAbilityPressPacket;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.util.ModTags;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.EnvironmentColorManager;
import net.mcreator.terramity.init.TerramityModKeyMappings;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="brutality", value={Dist.CLIENT})
public class ForgeClientPlayerStateHandler {
    private static boolean wasHoldingGpuAxe = false;
    private static int originalFps = -1;
    private static boolean originalVsync = false;
    private static boolean originalOcclusion = false;
    private static GraphicsStatus originalGfxMode;
    private static int originalRenderDist;
    public static final ResourceLocation BIT_SHADER;
    private static InteractionHand previousHand;

    @SubscribeEvent
    public static void onRenderNametag(RenderNameTagEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && ModUtils.hasFullArmorSet((LivingEntity)(player = (Player)entity), BrutalityArmorMaterials.NOIR)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (level == null || player == null) {
            return;
        }
        if (event.getAction() == 1) {
            if (!player.m_21023_((MobEffect)BrutalityModMobEffects.ENRAGED.get()) && Keybindings.RAGE_ACTIVATE_KEY.m_90859_()) {
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                    if (!handler.findCurios(stack -> stack.m_204117_(ModTags.Items.RAGE_ITEMS)).isEmpty()) {
                        player.getCapability(BrutalityCapabilities.PLAYER_RAGE_CAP).ifPresent(cap -> {
                            if (handler.findFirstCurio((Item)BrutalityModItems.ANGER_MANAGEMENT.get()).isPresent()) {
                                PacketHandler.sendToServer(new ServerboundActivateRagePacket());
                            }
                        });
                    }
                });
            }
            if (TerramityModKeyMappings.ACTIVE_ABILITY.m_90859_()) {
                PacketHandler.sendToServer(new ServerboundActiveAbilityPressPacket());
            }
        }
    }

    @SubscribeEvent
    public static void onClientLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        EnvironmentColorManager.resetAllColors();
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (level == null) return;
        if (player == null) {
            return;
        }
        boolean isHoldingGpuAxe = player.m_21055_((Item)BrutalityModItems.OLD_GPU.get());
        if (isHoldingGpuAxe) {
            if (!wasHoldingGpuAxe) {
                originalFps = (Integer)mc.f_91066_.m_232035_().m_231551_();
                originalVsync = (Boolean)mc.f_91066_.m_231817_().m_231551_();
                originalRenderDist = (Integer)mc.f_91066_.m_231984_().m_231551_();
                originalGfxMode = (GraphicsStatus)mc.f_91066_.m_232060_().m_231551_();
                originalOcclusion = (Boolean)mc.f_91066_.m_232070_().m_231551_();
                mc.f_91066_.m_231817_().m_231514_((Object)false);
            }
            mc.f_91063_.m_109128_(BIT_SHADER);
            if (!((GraphicsStatus)mc.f_91066_.m_232060_().m_231551_()).equals((Object)GraphicsStatus.FAST)) {
                mc.f_91066_.m_232060_().m_231514_((Object)GraphicsStatus.FAST);
            }
            if ((Integer)mc.f_91066_.m_232035_().m_231551_() != 10) {
                mc.f_91066_.m_232035_().m_231514_((Object)10);
            }
            if ((Integer)mc.f_91066_.m_231984_().m_231551_() != 2) {
                mc.f_91066_.m_231984_().m_231514_((Object)2);
            }
            if (((Boolean)mc.f_91066_.m_231817_().m_231551_()).booleanValue()) {
                mc.f_91066_.m_231817_().m_231514_((Object)false);
            }
            if (((Boolean)mc.f_91066_.m_232070_().m_231551_()).booleanValue()) {
                mc.f_91066_.m_232070_().m_231514_((Object)false);
            }
        } else if (wasHoldingGpuAxe) {
            mc.f_91066_.m_232035_().m_231514_((Object)originalFps);
            mc.f_91066_.m_231817_().m_231514_((Object)originalVsync);
            mc.f_91066_.m_231984_().m_231514_((Object)originalRenderDist);
            mc.f_91066_.m_232060_().m_231514_((Object)originalGfxMode);
            mc.f_91066_.m_232070_().m_231514_((Object)originalOcclusion);
            mc.f_91063_.m_109086_();
        }
        wasHoldingGpuAxe = isHoldingGpuAxe;
        EnvironmentColorManager.activeColorSources.clear();
        if (((Boolean)BrutalityClientConfig.BLACK_HOLE_SKY_COLOR.get()).booleanValue()) {
            boolean blackHoleNearby = StreamSupport.stream(level.m_104735_().spliterator(), false).anyMatch(e -> e.m_6095_() == BrutalityModEntities.BLACK_HOLE_ENTITY.get() && e.m_20280_((Entity)player) <= 100.0);
            EnvironmentColorManager.apply("black_hole", blackHoleNearby, new EnvironmentColorManager.ProximityColorSet().setColorAutoReset(EnvironmentColorManager.ColorType.SKY, FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0)).setColorAutoReset(EnvironmentColorManager.ColorType.FOG, FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0)));
        }
        if (((Boolean)BrutalityClientConfig.BORK_SKY_COLOR.get()).booleanValue()) {
            boolean playerNearEntityWithBork = StreamSupport.stream(level.m_104735_().spliterator(), false).anyMatch(e -> e instanceof Player && ((Player)e).m_21055_((Item)BrutalityModItems.BLADE_OF_THE_RUINED_KING.get()) && e.m_20280_((Entity)player) <= 100.0);
            EnvironmentColorManager.apply("bork", playerNearEntityWithBork, new EnvironmentColorManager.ProximityColorSet().setColorAutoReset(EnvironmentColorManager.ColorType.FOG, FastColor.ARGB32.m_13660_((int)255, (int)32, (int)92, (int)91)).setColorAutoReset(EnvironmentColorManager.ColorType.SKY, FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0)));
        }
        boolean rayNearby = StreamSupport.stream(level.m_104735_().spliterator(), false).anyMatch(e -> e.m_6095_() == BrutalityModEntities.EXPLOSION_RAY.get() && e.m_20280_((Entity)player) <= 2500.0);
        EnvironmentColorManager.apply("explosion_ray", rayNearby, new EnvironmentColorManager.ProximityColorSet().setColorAutoReset(EnvironmentColorManager.ColorType.SKY, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)140, (int)0)).setColorAutoReset(EnvironmentColorManager.ColorType.FOG, FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0)));
        EnvironmentColorManager.resolveAndApplyColors();
        if (ModList.get().isLoaded("bettercombat")) {
            return;
        }
        if (!mc.f_91066_.f_92096_.m_90857_()) return;
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        ItemCooldowns cooldowns = player.m_36335_();
        Item item = mainHand.m_41720_();
        if (item instanceof BrutalityThrowingItem) {
            BrutalityThrowingItem mainHandThrowingItem = (BrutalityThrowingItem)item;
            item = offHand.m_41720_();
            if (item instanceof BrutalityThrowingItem) {
                BrutalityThrowingItem offHandThrowingItem = (BrutalityThrowingItem)item;
                if (cooldowns.m_41519_((Item)mainHandThrowingItem)) {
                    return;
                }
                if (cooldowns.m_41519_((Item)offHandThrowingItem)) {
                    return;
                }
                if (previousHand == InteractionHand.OFF_HAND) {
                    mainHandThrowingItem.handleAttributesAndAnimation((Player)player, mainHand, false);
                    player.m_36334_();
                    previousHand = InteractionHand.MAIN_HAND;
                    return;
                }
                offHandThrowingItem.handleAttributesAndAnimation((Player)player, offHand, true);
                player.m_36334_();
                previousHand = InteractionHand.OFF_HAND;
                return;
            }
        }
        if (!((item = mainHand.m_41720_()) instanceof BrutalityThrowingItem)) return;
        BrutalityThrowingItem mainHandThrowingItem = (BrutalityThrowingItem)item;
        if (cooldowns.m_41519_((Item)mainHandThrowingItem)) {
            return;
        }
        mainHandThrowingItem.handleAttributesAndAnimation((Player)player, mainHand, false);
        player.m_36334_();
        previousHand = InteractionHand.OFF_HAND;
    }

    static {
        originalRenderDist = -1;
        BIT_SHADER = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"shaders/post/bits.json");
        previousHand = InteractionHand.OFF_HAND;
    }
}

