/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.spells.cosmic;

import com.lowdragmc.photon.client.fx.EntityEffect;
import java.util.List;
import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractPhysicsProjectile;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpellEntity;
import net.goo.brutality.magic.spells.cosmic.SingularityShiftSpell;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.registry.BrutalityModParticles;
import net.goo.brutality.util.ModResources;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SingularityShiftEntity
extends BrutalityAbstractPhysicsProjectile
implements BrutalityGeoEntity,
IBrutalitySpellEntity {
    private static final EntityDataAccessor<Integer> SPELL_LEVEL_DATA = SynchedEntityData.m_135353_(SingularityShiftEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> WEIGHTLESS_DATA = SynchedEntityData.m_135353_(SingularityShiftEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SingularityShiftEntity(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public String texture() {
        return "star_stream";
    }

    @Override
    public String model() {
        return "star_stream";
    }

    protected boolean m_142470_(Player pPlayer) {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    public float getSizeScaling() {
        return 0.0f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    @Override
    public int getSpellLevel() {
        return (Integer)this.f_19804_.m_135370_(SPELL_LEVEL_DATA);
    }

    @Override
    public void setSpellLevel(int spellLevel) {
        this.f_19804_.m_135381_(SPELL_LEVEL_DATA, (Object)spellLevel);
    }

    public boolean isWeightless() {
        return (Boolean)this.f_19804_.m_135370_(WEIGHTLESS_DATA);
    }

    public void setWeightless(boolean weightless) {
        this.f_19804_.m_135381_(WEIGHTLESS_DATA, (Object)weightless);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL_LEVEL_DATA, (Object)1);
        this.f_19804_.m_135372_(WEIGHTLESS_DATA, (Object)true);
    }

    @Override
    public float getGravity() {
        return 0.01f;
    }

    @Override
    protected int getLifespan() {
        return 1500;
    }

    @Override
    public BrutalitySpell getSpell() {
        return new SingularityShiftSpell();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("spell_level")) {
            this.setSpellLevel(tag.m_128451_("spell_level"));
        }
        if (tag.m_128441_("weightless")) {
            this.setWeightless(tag.m_128471_("weightless"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("spell_level", this.getSpellLevel());
        tag.m_128379_("weightless", this.isWeightless());
    }

    @Override
    protected void m_6532_(@NotNull HitResult hitResult) {
        super.m_6532_(hitResult);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)BrutalityModParticles.COSMIC_PARTICLE.get(0).get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 0.25, 0.25, 0.25, 0.0);
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)BrutalityModParticles.COSMIC_PARTICLE.get(1).get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 0.25, 0.25, 0.25, 0.0);
            this.stopTriggeredAnimation(null, "show");
        } else {
            EntityEffect gravityField = new EntityEffect(this.isWeightless() ? ModResources.GRAVITY_FIELD_UP_FX : ModResources.GRAVITY_FIELD_DOWN_FX, this.m_9236_(), (Entity)this, EntityEffect.AutoRotate.NONE);
            float scale = this.getSpell().getFinalStat(this.getSpellLevel(), this.getSpell().getStat(BrutalityTooltipHelper.SpellStatComponents.SIZE));
            scale *= 0.4f;
            gravityField.setScale((double)(1.0f + (scale -= 0.8f)), (double)(1.0f + scale), (double)(1.0f + scale));
            gravityField.start();
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.triggerAnim(null, "show");
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_36703_ && !this.m_9236_().m_5776_() && this.f_19797_ % 5 == 0) {
            BrutalitySpell spell = this.getSpell();
            float range = spell.getFinalStat(this.getSpellLevel(), spell.getStat(BrutalityTooltipHelper.SpellStatComponents.SIZE));
            List<LivingEntity> entities = ModUtils.getEntitiesInCylinder(LivingEntity.class, (Entity)this, e -> e != this, range + 0.5f, range * 2.0f);
            entities.forEach(e -> {
                MobEffectInstance effectInstance = new MobEffectInstance(this.isWeightless() ? (MobEffect)BrutalityModMobEffects.WEIGHTLESSNESS.get() : (MobEffect)BrutalityModMobEffects.HYPERGRAVITY.get(), 6, this.getSpellLevel(), false, true);
                e.m_7292_(effectInstance);
            });
        }
    }

    @Override
    protected int getInGroundLifespan() {
        return (int)this.getSpell().getFinalStat(this.getSpellLevel(), this.getSpell().getStat(BrutalityTooltipHelper.SpellStatComponents.DURATION));
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_271165_;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(RawAnimation.begin().thenPlayAndHold("hide"))).triggerableAnim("show", RawAnimation.begin().thenPlayAndHold("show"))});
    }

    @Override
    protected int getBounceCount() {
        return 0;
    }
}

