/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.trident.physics_projectile;

import com.lowdragmc.photon.client.fx.EntityEffect;
import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.config.BrutalityCommonConfig;
import net.goo.brutality.entity.base.BrutalityAbstractPhysicsThrowingProjectile;
import net.goo.brutality.entity.base.BrutalityAbstractThrowingProjectile;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.registry.BrutalityModParticles;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.ModResources;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BiomechReactor
extends BrutalityAbstractPhysicsThrowingProjectile
implements BrutalityGeoEntity {
    private static final EntityDataAccessor<Integer> HOMING_TARGET_ID = SynchedEntityData.m_135353_(BiomechReactor.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HOMING_COOLDOWN = SynchedEntityData.m_135353_(BiomechReactor.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BiomechReactor(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, pLevel, damageTypeResourceKey);
    }

    public BiomechReactor(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Player player, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, player, pLevel, damageTypeResourceKey);
    }

    @Override
    public float getGravity() {
        return 0.0f;
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("HomingTargetId", 3)) {
            this.f_19804_.m_135381_(HOMING_TARGET_ID, (Object)pCompound.m_128451_("HomingTargetId"));
        }
        if (pCompound.m_128425_("HitCount", 3)) {
            this.f_19804_.m_135381_(HOMING_COOLDOWN, (Object)pCompound.m_128451_("HomingCooldown"));
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOMING_TARGET_ID, (Object)-1);
        this.f_19804_.m_135372_(HOMING_COOLDOWN, (Object)25);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("HomingTargetId", ((Integer)this.f_19804_.m_135370_(HOMING_TARGET_ID)).intValue());
        pCompound.m_128405_("HomingCooldown", ((Integer)this.f_19804_.m_135370_(HOMING_COOLDOWN)).intValue());
    }

    @Override
    protected int getLifespan() {
        return 200;
    }

    @Override
    public void m_8119_() {
        int cooldown;
        if (this.f_19803_ && !(this.m_9236_() instanceof ServerLevel)) {
            EntityEffect rainbowTrail = new EntityEffect(ModResources.RAINBOW_TRAIL_FX, this.m_9236_(), (Entity)this, EntityEffect.AutoRotate.NONE);
            rainbowTrail.start();
        }
        if ((cooldown = ((Integer)this.f_19804_.m_135370_(HOMING_COOLDOWN)).intValue()) > 0) {
            this.f_19804_.m_135381_(HOMING_COOLDOWN, (Object)(cooldown - 1));
        } else if (!this.f_36703_ && !this.dealtDamage) {
            if ((Integer)this.f_19804_.m_135370_(HOMING_TARGET_ID) == -1) {
                LivingEntity nearestMob = this.m_9236_().m_45963_(LivingEntity.class, TargetingConditions.m_148352_().m_148355_().m_26893_().m_26888_(mob -> {
                    if (mob == this.m_19749_()) {
                        return false;
                    }
                    if (mob instanceof Player) {
                        Player player = (Player)mob;
                        return !player.m_7500_() && !player.m_5833_();
                    }
                    return true;
                }), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), new AABB(this.m_20183_()).m_82400_(25.0));
                if (nearestMob != null) {
                    this.f_19804_.m_135381_(HOMING_TARGET_ID, (Object)nearestMob.m_19879_());
                    this.m_9236_().m_245747_(this.m_20097_(), (SoundEvent)BrutalityModSounds.TARGET_FOUND.get(), SoundSource.AMBIENT, 4.0f, Mth.m_216267_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f), false);
                }
            } else {
                Entity target = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(HOMING_TARGET_ID)).intValue());
                if (target != null) {
                    this.collideWithBlocks = false;
                    Vec3 toVec = target.m_20318_(1.0f).m_82546_(this.m_20318_(1.0f));
                    double distance = toVec.m_82553_();
                    if (distance > 0.01) {
                        double scale = 2.5 / (distance * 2.0 + 0.1) + 0.25;
                        Vec3 motion = toVec.m_82541_().m_82490_(scale);
                        this.m_246865_(motion);
                        if (this.m_20184_().m_82553_() > 1.0) {
                            this.m_20256_(this.m_20184_().m_82490_(0.85));
                        }
                    }
                } else {
                    this.collideWithBlocks = true;
                }
            }
        }
        super.m_8119_();
    }

    protected boolean m_142470_(Player pPlayer) {
        return false;
    }

    @Override
    protected void m_6532_(@NotNull HitResult hitResult) {
        super.m_6532_(hitResult);
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            for (LivingEntity livingEntity : this.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.f_26872_.m_26893_().m_148355_(), owner, this.m_20191_().m_82400_(10.0))) {
                livingEntity.m_6469_(livingEntity.m_269291_().m_269036_((Entity)owner, (Entity)livingEntity), (float)((Integer)BrutalityCommonConfig.BIOMECH_REACTOR_DAMAGE.get()).intValue());
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.MIRACLE_BLIGHT.get(), 40, 0, false, false));
            }
        }
        this.m_5496_((SoundEvent)BrutalityModSounds.BIOMECH_REACTOR_BOOM.get(), 5.0f, Mth.m_216267_((RandomSource)this.f_19796_, (float)0.8f, (float)1.2f));
        this.m_146870_();
    }

    @Override
    protected void m_8060_(BlockHitResult hitResult) {
        super.m_8060_(hitResult);
        Vec3 location = hitResult.m_82450_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)BrutalityModParticles.BIOMECH_REACTOR_PARTICLE.get()), location.f_82479_, location.f_82480_, location.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void m_5790_(EntityHitResult hitResult) {
        LivingEntity livingEntity;
        Level level;
        super.m_5790_(hitResult);
        Entity hitEntity = hitResult.m_82443_();
        Vec3 location = hitResult.m_82450_();
        if (hitEntity instanceof LivingEntity && (level = (livingEntity = (LivingEntity)hitEntity).m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)BrutalityModParticles.BIOMECH_REACTOR_PARTICLE.get()), location.f_82479_, location.f_82480_ + (double)(hitEntity.m_20206_() / 2.0f), location.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected float getBounciness() {
        return 0.25f;
    }

    @Override
    public float getModelHeight() {
        return 16.0f;
    }
}

