/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.trident;

import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractTrident;
import net.goo.brutality.registry.BrutalityModSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class ThrownKnife
extends BrutalityAbstractTrident
implements BrutalityGeoEntity {
    public String knifeType = "chef";
    private static final EntityDataAccessor<String> KNIFE_TYPE = SynchedEntityData.m_135353_(ThrownKnife.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public ThrownKnife(Level pLevel, LivingEntity pShooter, ItemStack pStack, EntityType<? extends AbstractArrow> trident, String knifeType) {
        super(pLevel, pShooter, pStack, trident);
        this.setKnifeType(knifeType);
    }

    public ThrownKnife(EntityType<? extends BrutalityAbstractTrident> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public int getInGroundLifespan() {
        return 200;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(KNIFE_TYPE, (Object)"chef");
    }

    public void setKnifeType(String type) {
        this.f_19804_.m_135381_(KNIFE_TYPE, (Object)type);
        this.knifeType = type;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("KnifeType", this.getKnifeType());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setKnifeType(tag.m_128461_("KnifeType"));
    }

    public String getKnifeType() {
        return (String)this.f_19804_.m_135370_(KNIFE_TYPE);
    }

    @Override
    public String texture() {
        return "thrown_" + this.getKnifeType() + "_knife";
    }

    @Override
    protected Vec3 getTridentBounceStrength() {
        return new Vec3(-0.01, -0.01, -0.01);
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return (SoundEvent)BrutalityModSounds.KNIFE_BLOCK.get();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    @Override
    protected void m_5790_(EntityHitResult pResult) {
        pResult.m_82443_().f_19802_ = 0;
        super.m_5790_(pResult);
    }
}

