/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.generic;

import java.util.List;
import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.registry.BrutalityModParticles;
import net.goo.brutality.util.ModUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SupernovaAsteroid
extends ThrowableProjectile
implements BrutalityGeoEntity {
    public static final EntityDataAccessor<Integer> ANGLE_OFFSET = SynchedEntityData.m_135353_(SupernovaAsteroid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this, (boolean)true);
    float ORBIT_RADIUS = 6.0f;
    double FOLLOW_SPEED = 0.3;
    boolean trailSpawned = false;
    float orbitSpeed = 0.1f;

    public SupernovaAsteroid(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel, int angleOffset) {
        super(pEntityType, pLevel);
        this.f_19804_.m_135381_(ANGLE_OFFSET, (Object)angleOffset);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ANGLE_OFFSET, (Object)0);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_6532_(@NotNull HitResult pResult) {
        if (!this.m_9236_().f_46443_) {
            Entity target;
            if (pResult.m_6662_() == HitResult.Type.ENTITY && ((target = ((EntityHitResult)pResult).m_82443_()) != this.m_19749_() || target instanceof SupernovaAsteroid)) {
                target.m_6469_(target.m_269291_().m_269075_((Player)this.m_19749_()), 7.5f);
                this.explode();
            }
            if (pResult.m_6662_() == HitResult.Type.BLOCK) {
                this.explode();
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.trailSpawned) {
            this.trailSpawned = true;
        }
        if (this.m_19749_() != null) {
            float heightOffset = this.m_19749_().m_20206_() / 2.0f;
            double targetX = this.m_19749_().m_20185_() + (double)(Mth.m_14089_((float)((float)this.f_19797_ * this.orbitSpeed + (float)((Integer)this.f_19804_.m_135370_(ANGLE_OFFSET)).intValue())) * this.ORBIT_RADIUS);
            double targetZ = this.m_19749_().m_20189_() + (double)(Mth.m_14031_((float)((float)this.f_19797_ * this.orbitSpeed + (float)((Integer)this.f_19804_.m_135370_(ANGLE_OFFSET)).intValue())) * this.ORBIT_RADIUS);
            double targetY = this.m_19749_().m_20186_() + (double)heightOffset;
            Vec3 movement = new Vec3(targetX, targetY, targetZ).m_82546_(this.m_20182_());
            this.m_20256_(movement.m_82490_(this.FOLLOW_SPEED));
            List<Projectile> projectiles = this.m_9236_().m_45976_(Projectile.class, this.m_20191_()).stream().filter(projectile -> projectile.m_19749_() != this.m_19749_()).toList();
            if (!projectiles.isEmpty()) {
                for (Projectile projectile2 : projectiles) {
                    projectile2.m_142687_(Entity.RemovalReason.DISCARDED);
                    this.explode();
                }
            }
        } else {
            this.m_146870_();
        }
    }

    public void explode() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            for (int i = 0; i < serverLevel.f_46441_.m_188503_(50); ++i) {
                serverLevel.m_8767_((ParticleOptions)ModUtils.getRandomParticle(BrutalityModParticles.COSMIC_PARTICLE), this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 1, 0.0, 0.0, 0.0, 100.0);
            }
        }
        this.m_146870_();
    }
}

