/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.datagen;

import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import net.goo.brutality.Brutality;
import net.goo.brutality.item.base.BrutalityGeoItem;
import net.goo.brutality.item.weapon.axe.Deathsaw;
import net.goo.brutality.item.weapon.generic.TheCloudItem;
import net.goo.brutality.item.weapon.scythe.DarkinScythe;
import net.goo.brutality.item.weapon.sword.DullKnifeSword;
import net.goo.brutality.item.weapon.throwing.Mug;
import net.goo.brutality.item.weapon.throwing.StyrofoamCup;
import net.goo.brutality.registry.BrutalityModBlocks;
import net.goo.brutality.registry.BrutalityModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class BrutalityItemModelProvider
extends ItemModelProvider {
    private static final Set<Class<? extends BrutalityGeoItem>> EXCLUDED_ITEMS = Set.of(DullKnifeSword.class, DarkinScythe.class, TheCloudItem.class, Mug.class, StyrofoamCup.class, Deathsaw.class);

    public BrutalityItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "brutality", existingFileHelper);
    }

    protected void registerModels() {
        this.registerItemModels();
        this.registerConcreteVariantModels();
        this.withExistingParent(BrutalityModBlocks.TOILET.getId().m_135815_(), this.modLoc("block/" + BrutalityModBlocks.TOILET.getId().m_135815_()));
        this.withExistingParent(BrutalityModBlocks.URINAL.getId().m_135815_(), this.modLoc("block/" + BrutalityModBlocks.URINAL.getId().m_135815_()));
        this.withExistingParent(BrutalityModBlocks.UPPER_HVAC.getId().m_135815_(), this.modLoc("block/" + BrutalityModBlocks.UPPER_HVAC.getId().m_135815_()));
        this.withExistingParent(BrutalityModBlocks.LOWER_HVAC.getId().m_135815_(), this.modLoc("block/" + BrutalityModBlocks.LOWER_HVAC.getId().m_135815_()));
        this.withExistingParent(BrutalityModBlocks.OLD_AIR_CONDITIONER.getId().m_135815_(), this.modLoc("block/" + BrutalityModBlocks.OLD_AIR_CONDITIONER.getId().m_135815_()));
        this.withExistingParent(BrutalityModBlocks.EXIT_SIGN.getId().m_135815_(), this.modLoc("block/" + BrutalityModBlocks.EXIT_SIGN.getId().m_135815_()));
        this.withExistingParent(BrutalityModBlocks.OLD_SERVER_CASING.getId().m_135815_(), this.modLoc("block/" + BrutalityModBlocks.OLD_SERVER_CASING.getId().m_135815_()));
        this.withExistingParent(BrutalityModBlocks.OLD_SERVER_PANEL.getId().m_135815_(), this.modLoc("block/" + BrutalityModBlocks.OLD_SERVER_PANEL.getId().m_135815_() + "_one"));
        this.cubeAll(BrutalityModBlocks.PLASTERBOARD.getId().m_135815_(), this.modLoc("block/" + BrutalityModBlocks.PLASTERBOARD.getId().m_135815_()));
        BrutalityModBlocks.FILING_CABINETS.forEach(blockRegistryObject -> {
            String name = blockRegistryObject.getId().m_135815_();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("builtin/entity")))).texture("particle", this.modLoc("block/" + name))).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, -135.0f, 0.0f).scale(0.625f).end().transform(ItemDisplayContext.GROUND).translation(0.0f, 3.0f, 0.0f).scale(0.25f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 45.0f, 0.0f).scale(0.4f).end();
        });
        ((ItemModelBuilder)this.withExistingParent(BrutalityModBlocks.PUDDLE.getId().m_135815_(), this.modLoc("block/" + BrutalityModBlocks.PUDDLE.getId().m_135815_()))).renderType(this.mcLoc("translucent"));
        this.withExistingParent(BrutalityModBlocks.SMALL_OFFICE_LIGHT.getId().m_135815_(), this.modLoc("block/" + BrutalityModBlocks.SMALL_OFFICE_LIGHT.getId().m_135815_()));
        this.withExistingParent(BrutalityModBlocks.LIGHT_GRAY_OFFICE_RUG.getId().m_135815_(), this.modLoc("block/" + BrutalityModBlocks.LIGHT_GRAY_OFFICE_RUG.getId().m_135815_()));
        this.withExistingParent(BrutalityModBlocks.GRAY_OFFICE_RUG.getId().m_135815_(), this.modLoc("block/" + BrutalityModBlocks.GRAY_OFFICE_RUG.getId().m_135815_()));
    }

    protected void registerItemModels() {
        Collection itemsEntries = BrutalityModItems.ITEMS.getEntries();
        for (RegistryObject itemRegistryObject : itemsEntries) {
            Item item = (Item)itemRegistryObject.get();
            if (item instanceof BlockItem) continue;
            if (item instanceof BrutalityGeoItem) {
                String string;
                BrutalityGeoItem geoItem = (BrutalityGeoItem)item;
                if (EXCLUDED_ITEMS.contains(geoItem.getClass())) continue;
                String registryName = geoItem.getRegistryName();
                String category = geoItem.getCategoryAsString();
                boolean isCurio = geoItem instanceof ICurioItem;
                String string2 = isCurio ? "curio/" : "";
                if (geoItem instanceof ArmorItem) {
                    ArmorItem armorItem = (ArmorItem)geoItem;
                    string = armorItem.m_40401_().toString().toLowerCase(Locale.ROOT);
                } else {
                    string = registryName;
                }
                ResourceLocation basePath = this.modLoc("item/" + string2 + category + "/" + string + "/" + registryName);
                ResourceLocation handheldTexture = basePath.m_266382_("_handheld");
                ResourceLocation inventoryTexture = basePath.m_266382_("_inventory");
                ResourceLocation handheldModel = this.modLoc("item/" + category + "/" + registryName + "_handheld");
                boolean hasHandheldTexture = this.existingFileHelper.exists(handheldTexture, (ExistingFileHelper.IResourceType)TEXTURE);
                boolean hasInventoryTexture = this.existingFileHelper.exists(inventoryTexture, (ExistingFileHelper.IResourceType)TEXTURE);
                boolean hasHandheldModel = this.existingFileHelper.exists(handheldModel, (ExistingFileHelper.IResourceType)MODEL);
                if (hasHandheldTexture && hasInventoryTexture && hasHandheldModel) {
                    Brutality.LOGGER.info("generateSeparateTransforms({})", (Object)registryName);
                    this.generateSeparateTransforms(registryName, handheldTexture, inventoryTexture, handheldModel);
                    continue;
                }
                if (hasHandheldTexture) {
                    if (hasHandheldModel) {
                        Brutality.LOGGER.info("withExistingParentHandheld({})", (Object)registryName);
                        ((ItemModelBuilder)this.withExistingParent(registryName, handheldModel)).texture("layer0", handheldTexture);
                        continue;
                    }
                    ((ItemModelBuilder)this.withExistingParent(registryName, "item/handheld")).texture("layer0", handheldTexture);
                    continue;
                }
                if (!hasInventoryTexture) continue;
                Brutality.LOGGER.info("withExistingParentGenerated({})", (Object)registryName);
                ((ItemModelBuilder)this.withExistingParent(registryName, this.mcLoc("item/generated"))).texture("layer0", inventoryTexture);
                continue;
            }
            Brutality.LOGGER.info("basicItem({})", (Object)item);
            this.basicItem(item);
        }
    }

    protected void registerConcreteVariantModels() {
        for (DyeColor dyeColor : DyeColor.values()) {
            ResourceLocation slabName;
            ResourceLocation stairName = BrutalityModBlocks.CONCRETE_STAIRS.get(dyeColor.ordinal()).getId();
            if (stairName != null) {
                this.withExistingParent(String.valueOf(stairName), ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("block/" + stairName.m_135815_())));
            }
            if ((slabName = BrutalityModBlocks.CONCRETE_SLABS.get(dyeColor.ordinal()).getId()) == null) continue;
            this.withExistingParent(String.valueOf(slabName), ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("block/" + slabName.m_135815_())));
        }
    }

    private void generateSeparateTransforms(String name, ResourceLocation handheldTexture, ResourceLocation inventoryTexture, ResourceLocation handheldModel) {
        ItemModelBuilder baseModel = (ItemModelBuilder)((ItemModelBuilder)new ItemModelBuilder(this.modLoc(name + "_inventory"), this.existingFileHelper).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:item/generated"))).texture("layer0", inventoryTexture);
        ItemModelBuilder handModelBuilder = (ItemModelBuilder)((ItemModelBuilder)new ItemModelBuilder(this.modLoc(name + "_handheld"), this.existingFileHelper).parent((ModelFile)new ModelFile.UncheckedModelFile(handheldModel))).texture("layer0", handheldTexture);
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:item/handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)baseModel).perspective(ItemDisplayContext.GROUND, (ModelBuilder)handModelBuilder).perspective(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, (ModelBuilder)handModelBuilder).perspective(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, (ModelBuilder)handModelBuilder).perspective(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, (ModelBuilder)handModelBuilder).perspective(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, (ModelBuilder)handModelBuilder).end();
    }
}

