/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.datagen;

import net.goo.brutality.block.custom.CRTMonitorBlock;
import net.goo.brutality.block.custom.DustbinBlock;
import net.goo.brutality.block.custom.LCDMonitorBlock;
import net.goo.brutality.block.custom.OfficeCarpetBlock;
import net.goo.brutality.registry.BrutalityModBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BrutalityBlockStateProvider
extends BlockStateProvider {
    private static final String[] WORDS = new String[]{"", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen"};

    public BrutalityBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "brutality", exFileHelper);
    }

    private static String toWord(int i) {
        return i >= 1 && i <= 16 ? WORDS[i] : String.valueOf(i);
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(BrutalityModBlocks.WATER_COOLER_BLOCK);
        this.blockWithItem(BrutalityModBlocks.COFFEE_MACHINE_BLOCK);
        this.blockWithItem(BrutalityModBlocks.SUPER_SNIFFER_FIGURE_BLOCK);
        for (DyeColor dyeColor : DyeColor.values()) {
            String colorName = dyeColor.m_41065_();
            ResourceLocation texturePath = ResourceLocation.withDefaultNamespace((String)("block/" + colorName + "_concrete"));
            RegistryObject<Block> stair = BrutalityModBlocks.CONCRETE_STAIRS.get(dyeColor.ordinal());
            this.stairsBlock((StairBlock)stair.get(), texturePath, texturePath, texturePath);
            RegistryObject<Block> slab = BrutalityModBlocks.CONCRETE_SLABS.get(dyeColor.ordinal());
            this.slabBlock((SlabBlock)slab.get(), texturePath, texturePath);
        }
        ModelFile.ExistingModelFile upperHvac = this.models().getExistingFile(this.modLoc("block/upper_hvac"));
        this.horizontalBlock((Block)BrutalityModBlocks.UPPER_HVAC.get(), (ModelFile)upperHvac);
        ModelFile.ExistingModelFile lowerHvac = this.models().getExistingFile(this.modLoc("block/lower_hvac"));
        this.horizontalBlock((Block)BrutalityModBlocks.LOWER_HVAC.get(), (ModelFile)lowerHvac);
        ModelFile.ExistingModelFile oldAirCond = this.models().getExistingFile(this.modLoc("block/old_air_conditioner"));
        this.horizontalBlock((Block)BrutalityModBlocks.OLD_AIR_CONDITIONER.get(), (ModelFile)oldAirCond);
        ModelFile.ExistingModelFile toilet = this.models().getExistingFile(this.modLoc("block/toilet"));
        this.horizontalBlock((Block)BrutalityModBlocks.TOILET.get(), (ModelFile)toilet);
        ModelFile.ExistingModelFile urinal = this.models().getExistingFile(this.modLoc("block/urinal"));
        this.horizontalBlock((Block)BrutalityModBlocks.URINAL.get(), (ModelFile)urinal);
        ModelFile.ExistingModelFile oldServerCasing = this.models().getExistingFile(this.modLoc("block/old_server_casing"));
        this.randomRotationVerticalBlock((Block)BrutalityModBlocks.OLD_SERVER_CASING.get(), (ModelFile)oldServerCasing);
        ModelFile.ExistingModelFile exitSign = this.models().getExistingFile(this.modLoc("block/exit_sign"));
        this.horizontalFaceBlock((Block)BrutalityModBlocks.EXIT_SIGN.get(), (ModelFile)exitSign);
        ModelFile.ExistingModelFile smallOfficeLight = this.models().getExistingFile(this.modLoc("block/small_office_light"));
        this.horizontalFaceBlock((Block)BrutalityModBlocks.SMALL_OFFICE_LIGHT.get(), (ModelFile)smallOfficeLight);
        ModelFile.ExistingModelFile oldServerPanelOne = this.models().getExistingFile(this.modLoc("block/old_server_panel_one"));
        ModelFile.ExistingModelFile oldServerPanelTwo = this.models().getExistingFile(this.modLoc("block/old_server_panel_two"));
        this.getVariantBuilder((Block)BrutalityModBlocks.OLD_SERVER_PANEL.get()).forAllStates(arg_0 -> BrutalityBlockStateProvider.lambda$registerStatesAndModels$0((ModelFile)oldServerPanelOne, (ModelFile)oldServerPanelTwo, arg_0));
        ModelFile.ExistingModelFile puddle = this.models().getExistingFile(this.modLoc("block/puddle"));
        this.simpleBlock((Block)BrutalityModBlocks.PUDDLE.get(), (ModelFile)puddle);
        this.simpleBlock((Block)BrutalityModBlocks.PLASTERBOARD.get());
        BrutalityModBlocks.FILING_CABINETS.forEach(blockRegistryObject -> this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            int yRot = (dir.m_122416_() + 1) % 4 * 90;
            assert (blockRegistryObject.getId() != null);
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + blockRegistryObject.getId().m_135815_()))).rotationY(yRot).build();
        }));
        MultiPartBlockStateBuilder dustbinBuilder = this.getMultipartBuilder((Block)BrutalityModBlocks.DUSTBIN.get());
        ((MultiPartBlockStateBuilder.PartBuilder)dustbinBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/dustbin/none"))).addModel()).end();
        for (int i = 1; i <= 16; ++i) {
            String modelName = i == 16 ? "fifteen" : BrutalityBlockStateProvider.toWord(i);
            ((MultiPartBlockStateBuilder.PartBuilder)dustbinBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/dustbin/" + modelName))).addModel()).condition((Property)DustbinBlock.PAPERS, (Comparable[])new Integer[]{i}).end();
        }
        this.getVariantBuilder((Block)BrutalityModBlocks.CRT_MONITOR.get()).forAllStates(state -> {
            Direction facing = (Direction)state.m_61143_((Property)CRTMonitorBlock.f_54117_);
            boolean active = (Boolean)state.m_61143_((Property)CRTMonitorBlock.ACTIVE);
            String model = active ? "crt_monitor_active" : "crt_monitor";
            ConfiguredModel.Builder modelFile = ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + model)));
            if (facing != Direction.SOUTH) {
                int rotation = switch (facing) {
                    case Direction.NORTH -> 180;
                    case Direction.EAST -> 270;
                    case Direction.WEST -> 90;
                    default -> 0;
                };
                modelFile.rotationY(rotation);
            }
            return modelFile.build();
        });
        this.axisBlockSingleTexture((RotatedPillarBlock)BrutalityModBlocks.GRAY_OFFICE_RUG.get(), this.models().modLoc("block/" + BrutalityModBlocks.GRAY_OFFICE_CARPET.getId().m_135815_()));
        this.axisBlockSingleTexture((RotatedPillarBlock)BrutalityModBlocks.LIGHT_GRAY_OFFICE_RUG.get(), this.models().modLoc("block/" + BrutalityModBlocks.LIGHT_GRAY_OFFICE_CARPET.getId().m_135815_()));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)BrutalityModBlocks.LCD_MONITOR.get()).partialState().with((Property)LCDMonitorBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/lcd_monitor"))).addModel()).partialState().with((Property)LCDMonitorBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/lcd_monitor_active"))).addModel();
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)BrutalityModBlocks.GRAY_OFFICE_CARPET.get()).partialState().with(OfficeCarpetBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/gray_office_carpet"))).addModel()).partialState().with(OfficeCarpetBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/gray_office_carpet"))).rotationY(90).addModel();
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)BrutalityModBlocks.LIGHT_GRAY_OFFICE_CARPET.get()).partialState().with(OfficeCarpetBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/light_gray_office_carpet"))).addModel()).partialState().with(OfficeCarpetBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/light_gray_office_carpet"))).rotationY(90).addModel();
    }

    private void randomRotationVerticalBlock(Block block, ModelFile modelFile) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.allYRotations((ModelFile)modelFile, (int)0, (boolean)false));
    }

    public void axisBlockSingleTexture(RotatedPillarBlock block, ResourceLocation texture) {
        this.axisBlock(block, (ModelFile)this.models().cubeColumn(this.name((Block)block), texture, texture), (ModelFile)this.models().cubeColumnHorizontal(this.name((Block)block), texture, texture));
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        String name = blockRegistryObject.getId().m_135815_();
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("block/block"))).texture("particle", this.modLoc("block/" + name));
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)model);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$0(ModelFile oldServerPanelOne, ModelFile oldServerPanelTwo, BlockState state) {
        int yRot = (int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_();
        return new ConfiguredModel[]{new ConfiguredModel(oldServerPanelOne, 0, yRot, false), new ConfiguredModel(oldServerPanelTwo, 0, yRot, false)};
    }
}

