/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.client.renderers.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.goo.brutality.client.models.IRandomModelPart;
import net.goo.brutality.entity.capabilities.EntityCapabilities;
import net.goo.brutality.entity.spells.celestia.LightBinding;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityModEntities;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class LightBoundLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final EntityRenderDispatcher dispatcher;

    public LightBoundLayer(EntityRendererProvider.Context pContext, LivingEntityRenderer<T, M> livingEntityRenderer) {
        super(livingEntityRenderer);
        this.dispatcher = pContext.m_174022_();
    }

    protected void renderStuckItem(PoseStack poseStack, MultiBufferSource multiBufferSource, int pPackedLight, Entity entity, float pPartialTick, float rotationOffset, float spinAngle) {
        LightBinding lightBinding = new LightBinding((EntityType)BrutalityModEntities.LIGHT_BINDING.get(), entity.m_9236_());
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotationOffset));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(spinAngle));
        this.dispatcher.m_114384_((Entity)lightBinding, 0.0, 0.0, 0.0, 0.0f, pPartialTick, poseStack, multiBufferSource, pPackedLight);
    }

    public void render(@NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, @NotNull T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (pLivingEntity.getCapability(BrutalityCapabilities.ENTITY_EFFECT_CAP).map(EntityCapabilities.EntityEffectCap::isLightBound).orElse(false).booleanValue() && this.m_117386_() instanceof IRandomModelPart) {
            float scale = Math.max(pLivingEntity.m_20205_(), pLivingEntity.m_20206_()) * 0.5f;
            for (int j = 0; j < 2; ++j) {
                pPoseStack.m_85836_();
                pPoseStack.m_252880_(0.0f, 3.0f / pLivingEntity.m_20206_() * 0.25f, 0.0f);
                pPoseStack.m_85841_(scale, scale, scale);
                float rotationOffset = j == 0 ? 45.0f : -45.0f;
                float spinAngle = pAgeInTicks * 5.0f % 360.0f;
                this.renderStuckItem(pPoseStack, pBuffer, pPackedLight, (Entity)pLivingEntity, pPartialTick, rotationOffset, spinAngle);
                pPoseStack.m_85849_();
            }
        }
    }
}

