/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.client.entity;

import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityRay;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpellEntity;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class BrutalityGeoEntityModel<T extends Entity>
extends GeoModel<T> {
    public GeoEntityRenderer<T> renderer;

    public ResourceLocation getModelResource(T animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("geo/entity/" + (((BrutalityGeoEntity)animatable).model() != null ? ((BrutalityGeoEntity)animatable).model() : ForgeRegistries.ENTITY_TYPES.getKey((Object)animatable.m_6095_()).m_135815_()) + ".geo.json"));
    }

    public ResourceLocation getTextureResource(T animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("textures/entity/" + (((BrutalityGeoEntity)animatable).texture() != null ? ((BrutalityGeoEntity)animatable).texture() : ForgeRegistries.ENTITY_TYPES.getKey((Object)animatable.m_6095_()).m_135815_()) + ".png"));
    }

    public ResourceLocation getAnimationResource(T animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("animations/entity/" + (((BrutalityGeoEntity)animatable).animation() != null ? ((BrutalityGeoEntity)animatable).animation() : ForgeRegistries.ENTITY_TYPES.getKey((Object)animatable.m_6095_()).m_135815_()) + ".animation.json"));
    }

    public void setCustomAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        super.setCustomAnimations(animatable, instanceId, animationState);
        if (animatable instanceof BrutalityRay) {
            BrutalityRay ray = (BrutalityRay)animatable;
            CoreGeoBone mainBeam = this.getAnimationProcessor().getBone("main_beam");
            if (mainBeam != null) {
                mainBeam.setScaleY(ray.getDataMaxLength());
                if (ray instanceof IBrutalitySpellEntity) {
                    IBrutalitySpellEntity spellEntity = (IBrutalitySpellEntity)((Object)ray);
                    BrutalitySpell spell = spellEntity.getSpell();
                    if (spellEntity.getSpell().getStat(BrutalityTooltipHelper.SpellStatComponents.SIZE) != null) {
                        float desiredSize = spell.getFinalStat(spellEntity.getSpellLevel(), spellEntity.getSpell().getStat(BrutalityTooltipHelper.SpellStatComponents.SIZE));
                        float baseSize = spell.getStat(BrutalityTooltipHelper.SpellStatComponents.SIZE).base();
                        float scale = desiredSize / baseSize;
                        mainBeam.setScaleX(mainBeam.getScaleX() * scale);
                        mainBeam.setScaleZ(mainBeam.getScaleZ() * scale);
                    }
                }
            }
        }
    }
}

