/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.client;

import java.util.Map;
import net.goo.brutality.Brutality;
import net.goo.brutality.entity.spells.brimwielder.ExtinctionEntity;
import net.goo.brutality.event.LivingDodgeEvent;
import net.goo.brutality.item.base.BrutalityAnkletItem;
import net.goo.brutality.network.ClientboundDodgePacket;
import net.goo.brutality.network.ClientboundParticlePacket;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.sounds.DeathsawSoundInstance;
import net.goo.brutality.sounds.ExtinctionSpellSoundInstance;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientAccess {
    private static ExtinctionSpellSoundInstance extinctionSpellSoundInstance;
    private static DeathsawSoundInstance deathsawSoundInstance;

    public static void syncCapabilities(int entityId, Map<String, CompoundTag> data) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(entityId);
        if (entity == null) {
            return;
        }
        for (Map.Entry<String, CompoundTag> entry : data.entrySet()) {
            String key = entry.getKey();
            CompoundTag tag = entry.getValue();
            Capability<? extends INBTSerializable<CompoundTag>> cap = BrutalityCapabilities.CapabilitySyncRegistry.get(key);
            if (cap == null) continue;
            entity.getCapability(cap).ifPresent(inst -> ((INBTSerializable)inst).deserializeNBT((Tag)tag));
        }
    }

    public static void playExtinctionSpellSound(ExtinctionEntity extinctionEntity) {
        extinctionSpellSoundInstance = new ExtinctionSpellSoundInstance(extinctionEntity);
        Minecraft.m_91087_().m_91106_().m_120372_((TickableSoundInstance)extinctionSpellSoundInstance);
    }

    public static void stopExtinctionSpellSound() {
        Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)extinctionSpellSoundInstance);
    }

    public static void startDeathsawSound(Player player) {
        deathsawSoundInstance = new DeathsawSoundInstance((LivingEntity)player);
        player.m_5496_((SoundEvent)BrutalityModSounds.CHAINSAW_START.get(), 1.0f, 1.0f);
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        if (deathsawSoundInstance.m_7767_() && !soundManager.m_120403_((SoundInstance)deathsawSoundInstance)) {
            Minecraft.m_91087_().m_91106_().m_120369_((SoundInstance)deathsawSoundInstance, 23);
        }
    }

    public static void stopDeathsawSound(LivingEntity livingEntity) {
        livingEntity.m_5496_((SoundEvent)BrutalityModSounds.CHAINSAW_STOP.get(), 1.0f, 1.0f);
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        if (soundManager.m_120403_((SoundInstance)deathsawSoundInstance)) {
            soundManager.m_120399_((SoundInstance)deathsawSoundInstance);
        }
    }

    public static void syncItemCooldowns(Map<Item, ItemCooldowns.CooldownInstance> cooldowns, int tickCount) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ItemCooldowns newCooldowns = player.m_36335_();
            newCooldowns.f_41515_.clear();
            newCooldowns.f_41515_.putAll(cooldowns);
            newCooldowns.f_41516_ = tickCount;
        }
    }

    public static void spawnParticles(ClientboundParticlePacket packet) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        for (int i = 0; i < packet.count; ++i) {
            float xOffset = (float)(level.f_46441_.m_188583_() * (double)packet.xDist);
            float yOffset = (float)(level.f_46441_.m_188583_() * (double)packet.yDist);
            float zOffset = (float)(level.f_46441_.m_188583_() * (double)packet.zDist);
            try {
                level.m_6493_(packet.particle, packet.overrideLimiter, (double)(packet.x + xOffset), (double)(packet.y + yOffset), (double)(packet.z + zOffset), (double)packet.xSpeed, (double)packet.ySpeed, (double)packet.zSpeed);
                continue;
            }
            catch (Throwable throwable) {
                Brutality.LOGGER.warn("Could not spawn particle effect {}: {}", (Object)packet.particle, (Object)throwable.getMessage());
                return;
            }
        }
    }

    public static void handleDodgeClient(ClientboundDodgePacket packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Holder.Reference damageType = level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)packet.damageTypeId));
        Entity directEntity = packet.hasDirectEntity && packet.directEntityId != null ? level.m_6815_(packet.directEntityId.intValue()) : null;
        Entity causingEntity = packet.hasCausingEntity && packet.causingEntityId != null ? level.m_6815_(packet.causingEntityId.intValue()) : null;
        DamageSource source = new DamageSource((Holder)damageType, directEntity, causingEntity);
        Entity entity = level.m_6815_(packet.entityId);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            LivingDodgeEvent.Client client = new LivingDodgeEvent.Client(livingEntity, source, packet.amount);
            MinecraftForge.EVENT_BUS.post((Event)client);
            Item item = packet.anklet.m_41720_();
            if (item instanceof BrutalityAnkletItem) {
                BrutalityAnkletItem ankletItem = (BrutalityAnkletItem)item;
                ankletItem.onDodgeClient(livingEntity, source, packet.amount, packet.anklet);
            }
        }
    }
}

