/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.block.block_entity;

import net.goo.brutality.block.BrutalityGeoBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SuperSnifferFigureBlockEntity
extends BlockEntity
implements BrutalityGeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int texture = 0;
    private int pose = 0;
    static String[] textures = new String[]{"", "_super", "_blue", "_ultra"};

    public SuperSnifferFigureBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public String texture(Block block) {
        return "super_sniffer_figure" + textures[this.getTexture()];
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.m_58900_();
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<SuperSnifferFigureBlockEntity> state) {
        SuperSnifferFigureBlockEntity blockEntity = (SuperSnifferFigureBlockEntity)state.getData(DataTickets.BLOCK_ENTITY);
        state.getController().setAnimation(RawAnimation.begin().thenPlayAndHold("pose_" + blockEntity.getPose()));
        return PlayState.CONTINUE;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("texture", this.texture);
        tag.m_128405_("pose", this.pose);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag.m_128425_("texture", 3)) {
            this.texture = tag.m_128451_("texture");
        }
        if (tag.m_128425_("pose", 3)) {
            this.pose = tag.m_128451_("pose");
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("texture", this.texture);
        tag.m_128405_("pose", this.pose);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("texture", 3)) {
            this.texture = tag.m_128451_("texture");
        }
        if (tag.m_128425_("pose", 3)) {
            this.pose = tag.m_128451_("pose");
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setTexture(int texture) {
        this.texture = texture;
        this.m_6596_();
    }

    public void setPose(int pose) {
        this.pose = pose;
        this.m_6596_();
    }

    public int getTexture() {
        return this.texture;
    }

    public int getPose() {
        return this.pose;
    }
}

