/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.network;

import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.client.render.ClientStorageContentsTooltipBase;
import net.p3pp3rf1y.sophisticatedcore.network.ISplittableMessage;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;

public class StorageContentsMessage
implements ISplittableMessage {
    private final UUID shulkerBoxUuid;
    @Nullable
    private final CompoundTag contents;

    public StorageContentsMessage(UUID shulkerBoxUuid, @Nullable CompoundTag contents) {
        this.shulkerBoxUuid = shulkerBoxUuid;
        this.contents = contents;
    }

    public static void encode(StorageContentsMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130077_(msg.shulkerBoxUuid);
        packetBuffer.m_130079_(msg.contents);
    }

    public static StorageContentsMessage decode(FriendlyByteBuf packetBuffer) {
        return new StorageContentsMessage(packetBuffer.m_130259_(), packetBuffer.m_130261_());
    }

    static void onMessage(StorageContentsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> StorageContentsMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(StorageContentsMessage msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || msg.contents == null) {
            return;
        }
        ItemContentsStorage.get().setStorageContents(msg.shulkerBoxUuid, msg.contents);
        ClientStorageContentsTooltipBase.refreshContents();
    }
}

