/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IFillLevelDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.ILockable;
import net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IUpgradeDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageToolItem
extends ItemBase {
    private static final String CONTROLLER_POS_TAG = "controllerPos";
    private static final String MODE_TAG = "mode";

    public StorageToolItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag flag) {
        tooltipComponents.addAll(StorageTranslationHelper.INSTANCE.getTranslatedLines(stack.m_41720_().m_5524_() + ".tooltip", null, new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
        String itemName = RegistryHelper.getItemKey((Item)stack.m_41720_()).m_135815_();
        tooltipComponents.add((Component)Component.m_237110_((String)(StorageTranslationHelper.INSTANCE.translItemTooltip(itemName) + ".controls"), (Object[])new Object[]{Component.m_237115_((String)(StorageTranslationHelper.INSTANCE.translItemTooltip(itemName) + ".controls.combination")).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GRAY));
    }

    public static void useOffHandOnPlaced(ItemStack tool, StorageBlockEntity be) {
        if (be.m_58904_().m_5776_()) {
            return;
        }
        Mode mode = StorageToolItem.getMode(tool);
        if (mode == Mode.LINK) {
            StorageToolItem.getControllerLink(tool).ifPresentOrElse(be::linkToController, () -> ((StorageBlockEntity)be).unlinkFromController());
        } else if (mode == Mode.LOCK) {
            be.toggleLock();
        }
    }

    public InteractionResult onItemUseFirst(ItemStack tool, UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        Block blockClicked = level.m_8055_(pos).m_60734_();
        Mode mode = StorageToolItem.getMode(tool);
        switch (mode) {
            case LINK: {
                if (!this.tryLinking(pos, level, blockClicked, tool)) break;
                return InteractionResult.SUCCESS;
            }
            case LOCK: {
                if (!StorageToolItem.tryToggling(pos, level, ILockable.class, ILockable::toggleLock)) break;
                return InteractionResult.SUCCESS;
            }
            case COUNT_DISPLAY: {
                if (!StorageToolItem.tryToggling(pos, level, ICountDisplay.class, ICountDisplay::toggleCountVisibility)) break;
                return InteractionResult.SUCCESS;
            }
            case LOCK_DISPLAY: {
                if (!StorageToolItem.tryToggling(pos, level, ILockable.class, ILockable::toggleLockVisibility)) break;
                return InteractionResult.SUCCESS;
            }
            case TIER_DISPLAY: {
                if (!StorageToolItem.tryToggling(pos, level, ITierDisplay.class, ITierDisplay::toggleTierVisiblity)) break;
                return InteractionResult.SUCCESS;
            }
            case UPGRADES_DISPLAY: {
                if (!StorageToolItem.tryToggling(pos, level, IUpgradeDisplay.class, IUpgradeDisplay::toggleUpgradesVisiblity)) break;
                return InteractionResult.SUCCESS;
            }
            case FILL_LEVEL_DISPLAY: {
                if (!StorageToolItem.tryToggling(pos, level, IFillLevelDisplay.class, IFillLevelDisplay::toggleFillLevelVisibility)) break;
                return InteractionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(tool, context);
    }

    private static <T> boolean tryToggling(BlockPos pos, Level level, Class<T> clazz, Consumer<T> toggle) {
        return WorldHelper.getLoadedBlockEntity((Level)level, (BlockPos)pos, clazz).map(be -> {
            if (level.m_5776_()) {
                return true;
            }
            toggle.accept(be);
            return true;
        }).orElse(false);
    }

    private boolean tryLinking(BlockPos pos, Level level, Block blockClicked, ItemStack tool) {
        if (blockClicked == ModBlocks.CONTROLLER.get()) {
            this.setControllerLink(tool, pos);
            return true;
        }
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ILinkable.class).map(linkable -> {
            StorageToolItem.getControllerLink(tool).ifPresentOrElse(arg_0 -> ((ILinkable)linkable).linkToController(arg_0), () -> ((ILinkable)linkable).unlinkFromController());
            return true;
        }).orElse(false);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack tool;
        if (player.m_6144_() && StorageToolItem.getControllerLink(tool = player.m_21120_(usedHand)).isPresent()) {
            this.removeControllerLink(tool);
            return InteractionResultHolder.m_19090_((Object)tool);
        }
        return super.m_7203_(level, player, usedHand);
    }

    private void setControllerLink(ItemStack tool, BlockPos pos) {
        NBTHelper.setLong((ItemStack)tool, (String)CONTROLLER_POS_TAG, (long)pos.m_121878_());
    }

    public static Optional<BlockPos> getControllerLink(ItemStack tool) {
        return NBTHelper.getLong((ItemStack)tool, (String)CONTROLLER_POS_TAG).map(BlockPos::m_122022_);
    }

    private void removeControllerLink(ItemStack tool) {
        NBTHelper.removeTag((ItemStack)tool, (String)CONTROLLER_POS_TAG);
    }

    public static Component getOverlayMessage(ItemStack tool) {
        Mode mode = StorageToolItem.getMode(tool);
        Item item = tool.m_41720_();
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.LINK -> StorageToolItem.getControllerLink(tool).map(controllerPos -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "linking", controllerPos.m_123341_(), controllerPos.m_123342_(), controllerPos.m_123343_())).orElseGet(() -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "unlinking", new Object[0]));
            case Mode.LOCK -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_lock", new Object[0]);
            case Mode.LOCK_DISPLAY -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_lock_display", new Object[0]);
            case Mode.COUNT_DISPLAY -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_count_display", new Object[0]);
            case Mode.TIER_DISPLAY -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_tier_display", new Object[0]);
            case Mode.UPGRADES_DISPLAY -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_upgrades_display", new Object[0]);
            case Mode.FILL_LEVEL_DISPLAY -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_fill_level_display", new Object[0]);
        };
    }

    public static Mode getMode(ItemStack tool) {
        return NBTHelper.getEnumConstant((ItemStack)tool, (String)MODE_TAG, Mode::valueOf).orElse(Mode.LINK);
    }

    public static void cycleMode(ItemStack tool, boolean next) {
        NBTHelper.setEnumConstant((ItemStack)tool, (String)MODE_TAG, (Enum)(next ? StorageToolItem.getMode(tool).next() : StorageToolItem.getMode(tool).previous()));
    }

    public static enum Mode implements StringRepresentable
    {
        LINK,
        LOCK,
        COUNT_DISPLAY,
        LOCK_DISPLAY,
        TIER_DISPLAY,
        UPGRADES_DISPLAY,
        FILL_LEVEL_DISPLAY;


        public Mode next() {
            return Mode.values()[(this.ordinal() + 1) % Mode.values().length];
        }

        public Mode previous() {
            return Mode.values()[Math.floorMod(this.ordinal() - 1, Mode.values().length)];
        }

        public String m_7912_() {
            return this.name();
        }
    }
}

