/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ITintable;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.IMaterialHolder;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.util.DecorationHelper;

public class PaintbrushItem
extends ItemBase {
    private static final String BARREL_MATERIALS_TAG = "barrelMaterials";
    private static final String MAIN_COLOR_TAG = "mainColor";
    private static final String ACCENT_COLOR_TAG = "accentColor";
    private static final String REMAINING_PARTS_TAG = "remainingParts";

    public PaintbrushItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public static void setBarrelMaterials(ItemStack paintbrush, Map<BarrelMaterial, ResourceLocation> materials) {
        NBTHelper.putMap((CompoundTag)paintbrush.m_41784_(), (String)BARREL_MATERIALS_TAG, materials, BarrelMaterial::m_7912_, resourceLocation -> StringTag.m_129297_((String)resourceLocation.toString()));
        PaintbrushItem.resetMainColor(paintbrush);
        PaintbrushItem.resetAccentColor(paintbrush);
    }

    public static Optional<ItemRequirements> getItemRequirements(ItemStack paintbrush, Player player, Level level, BlockPos lookingAtPos) {
        HashMap<BarrelMaterial, ResourceLocation> materialsToApply = new HashMap<BarrelMaterial, ResourceLocation>(PaintbrushItem.getBarrelMaterials(paintbrush));
        BlockEntity be = level.m_7702_(lookingAtPos);
        if (be == null) {
            return Optional.empty();
        }
        if (!materialsToApply.isEmpty()) {
            return PaintbrushItem.getMaterialItemRequirements(paintbrush, player, be, materialsToApply);
        }
        return PaintbrushItem.getDyeItemRequirements(paintbrush, player, be);
    }

    private static Optional<ItemRequirements> getMaterialItemRequirements(ItemStack paintbrush, Player player, BlockEntity be, Map<BarrelMaterial, ResourceLocation> materialsToApply) {
        HashMap<ResourceLocation, Integer> allPartsNeeded = new HashMap();
        if (be instanceof IMaterialHolder) {
            IMaterialHolder materialHolder = (IMaterialHolder)be;
            allPartsNeeded = PaintbrushItem.getMaterialHolderPartsNeeded(materialsToApply, materialHolder);
        } else if (be instanceof ControllerBlockEntity) {
            ControllerBlockEntity controllerBe = (ControllerBlockEntity)be;
            for (BlockPos storagePosition : controllerBe.getStoragePositions()) {
                PaintbrushItem.addStorageMaterialPartsNeeded(materialsToApply, controllerBe, storagePosition, allPartsNeeded);
            }
        }
        if (allPartsNeeded.isEmpty()) {
            return Optional.empty();
        }
        return PaintbrushItem.getItemRequirements(paintbrush, player, allPartsNeeded);
    }

    public static Optional<ItemRequirements> getItemRequirements(ItemStack paintbrush, Player player, Map<ResourceLocation, Integer> allPartsNeeded) {
        Map<ResourceLocation, Integer> remainingParts = PaintbrushItem.getRemainingParts(paintbrush);
        DecorationHelper.ConsumptionResult result = DecorationHelper.consumeMaterialPartsNeeded(allPartsNeeded, remainingParts, InventoryHelper.getItemHandlersFromPlayerIncludingContainers((Player)player), true);
        ArrayList<ItemStack> itemsPresent = new ArrayList<ItemStack>();
        ArrayList<ItemStack> itemsMissing = new ArrayList<ItemStack>();
        for (Map.Entry<ResourceLocation, Integer> entry : allPartsNeeded.entrySet()) {
            ResourceLocation part = entry.getKey();
            int count = PaintbrushItem.ceilDiv(entry.getValue() - remainingParts.getOrDefault(part, 0), 24);
            int missing = PaintbrushItem.ceilDiv(result.missingParts().getOrDefault(part, 0), 24);
            int present = count - missing;
            BuiltInRegistries.f_257033_.m_6612_(part).ifPresent(item -> {
                if (missing > 0) {
                    itemsMissing.add(new ItemStack((ItemLike)item, missing));
                }
                if (present > 0) {
                    itemsPresent.add(new ItemStack((ItemLike)item, present));
                }
            });
        }
        return Optional.of(new ItemRequirements(itemsPresent, itemsMissing));
    }

    private static int ceilDiv(int x, int y) {
        return (int)Math.ceil((double)x / (double)y);
    }

    private static void addStorageMaterialPartsNeeded(Map<BarrelMaterial, ResourceLocation> materialsToApply, ControllerBlockEntity controllerBe, BlockPos storagePosition, Map<ResourceLocation, Integer> allPartsNeeded) {
        WorldHelper.getBlockEntity((BlockGetter)controllerBe.m_58904_(), (BlockPos)storagePosition, IMaterialHolder.class).ifPresent(materialHolder -> {
            Map<ResourceLocation, Integer> storagePartsNeeded = PaintbrushItem.getMaterialHolderPartsNeeded(materialsToApply, materialHolder);
            storagePartsNeeded.forEach((part, count) -> allPartsNeeded.merge((ResourceLocation)part, (Integer)count, Integer::sum));
        });
    }

    private static Optional<ItemRequirements> getDyeItemRequirements(ItemStack paintbrush, Player player, BlockEntity be) {
        int mainColorToSet = PaintbrushItem.getMainColor(paintbrush) & 0xFFFFFF;
        int accentColorToSet = PaintbrushItem.getAccentColor(paintbrush) & 0xFFFFFF;
        HashMap<TagKey<Item>, Integer> allPartsNeeded = new HashMap();
        if (be instanceof StorageBlockEntity) {
            StorageBlockEntity storageBe = (StorageBlockEntity)be;
            allPartsNeeded = PaintbrushItem.getStorageDyePartsNeeded(mainColorToSet, accentColorToSet, (ITintable)storageBe.getStorageWrapper());
        } else if (be instanceof ControllerBlockEntity) {
            ControllerBlockEntity controllerBe = (ControllerBlockEntity)be;
            for (BlockPos storagePosition : controllerBe.getStoragePositions()) {
                PaintbrushItem.addStorageDyePartsNeeded(mainColorToSet, accentColorToSet, controllerBe, storagePosition, allPartsNeeded);
            }
        }
        if (allPartsNeeded.isEmpty()) {
            return Optional.empty();
        }
        return PaintbrushItem.getDyeItemRequirements(paintbrush, player, allPartsNeeded);
    }

    public static Optional<ItemRequirements> getDyeItemRequirements(ItemStack paintbrush, Player player, Map<TagKey<Item>, Integer> allPartsNeeded) {
        Map<ResourceLocation, Integer> remainingParts = PaintbrushItem.getRemainingParts(paintbrush);
        DecorationHelper.ConsumptionResult result = DecorationHelper.consumeDyePartsNeeded(allPartsNeeded, InventoryHelper.getItemHandlersFromPlayerIncludingContainers((Player)player), remainingParts, true);
        return PaintbrushItem.compileDyeItemRequirements(allPartsNeeded, remainingParts, result);
    }

    private static void addStorageDyePartsNeeded(int mainColorToSet, int accentColorToSet, ControllerBlockEntity controllerBe, BlockPos storagePosition, Map<TagKey<Item>, Integer> allPartsNeeded) {
        WorldHelper.getBlockEntity((BlockGetter)controllerBe.m_58904_(), (BlockPos)storagePosition, StorageBlockEntity.class).ifPresent(storageBe -> {
            Map<TagKey<Item>, Integer> storagePartsNeeded = PaintbrushItem.getStorageDyePartsNeeded(mainColorToSet, accentColorToSet, (ITintable)storageBe.getStorageWrapper());
            storagePartsNeeded.forEach((part, count) -> allPartsNeeded.merge((TagKey<Item>)part, (Integer)count, Integer::sum));
        });
    }

    public static Map<TagKey<Item>, Integer> getStorageDyePartsNeeded(int mainColorToSet, int accentColorToSet, ITintable tintable) {
        return DecorationHelper.getDyePartsNeeded(mainColorToSet, accentColorToSet, tintable.getMainColor(), tintable.getAccentColor());
    }

    private static Optional<ItemRequirements> compileDyeItemRequirements(Map<TagKey<Item>, Integer> allPartsNeeded, Map<ResourceLocation, Integer> remainingParts, DecorationHelper.ConsumptionResult result) {
        ArrayList<ItemStack> itemsPresent = new ArrayList<ItemStack>();
        ArrayList<ItemStack> itemsMissing = new ArrayList<ItemStack>();
        for (Map.Entry<TagKey<Item>, Integer> entry : allPartsNeeded.entrySet()) {
            Item dyeItem;
            TagKey<Item> part = entry.getKey();
            int count = PaintbrushItem.ceilDiv(entry.getValue() - remainingParts.getOrDefault(part.f_203868_(), 0), 24);
            int missing = PaintbrushItem.ceilDiv(result.missingParts().getOrDefault(part.f_203868_(), 0), 24);
            int present = count - missing;
            if (part == Tags.Items.DYES_RED) {
                dyeItem = Items.f_42497_;
            } else if (part == Tags.Items.DYES_GREEN) {
                dyeItem = Items.f_42496_;
            } else {
                if (part != Tags.Items.DYES_BLUE) continue;
                dyeItem = Items.f_42494_;
            }
            if (missing > 0) {
                itemsMissing.add(new ItemStack((ItemLike)dyeItem, missing));
            }
            if (present <= 0) continue;
            itemsPresent.add(new ItemStack((ItemLike)dyeItem, present));
        }
        return Optional.of(new ItemRequirements(itemsPresent, itemsMissing));
    }

    public static Map<ResourceLocation, Integer> getMaterialHolderPartsNeeded(Map<BarrelMaterial, ResourceLocation> materialsToApply, IMaterialHolder materialHolder) {
        HashMap<BarrelMaterial, ResourceLocation> originalMaterials = new HashMap<BarrelMaterial, ResourceLocation>(materialHolder.getMaterials());
        BarrelBlockItem.uncompactMaterials(originalMaterials);
        return DecorationHelper.getMaterialPartsNeeded(originalMaterials, materialsToApply);
    }

    public InteractionResult onItemUseFirst(ItemStack paintbrush, UseOnContext context) {
        if (!(PaintbrushItem.hasMainColor(paintbrush) || PaintbrushItem.hasAccentColor(paintbrush) || PaintbrushItem.hasBarrelMaterials(paintbrush))) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockEntity be = level.m_7702_(context.m_8083_());
        if (be instanceof StorageBlockEntity) {
            StorageBlockEntity storageBe = (StorageBlockEntity)be;
            if (!level.m_5776_()) {
                PaintbrushItem.paintStorage(context.m_43723_(), paintbrush, storageBe, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (be instanceof ControllerBlockEntity) {
            ControllerBlockEntity controllerBe = (ControllerBlockEntity)be;
            if (!level.m_5776_()) {
                this.paintConnectedStorages(context.m_43723_(), level, paintbrush, controllerBe);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void paintConnectedStorages(@Nullable Player player, Level level, ItemStack paintbrush, ControllerBlockEntity controllerBe) {
        if (player == null) {
            return;
        }
        for (BlockPos pos : controllerBe.getStoragePositions()) {
            WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(storageBe -> PaintbrushItem.paintStorage(player, paintbrush, storageBe, 0.6f));
        }
    }

    private static void paintStorage(@Nullable Player player, ItemStack paintbrush, StorageBlockEntity storageBe, float soundVolume) {
        Direction effectOffsetDirection;
        BlockState state;
        Block block;
        IMaterialHolder materialHolder;
        if (player == null) {
            return;
        }
        StorageWrapper tintable = storageBe.getStorageWrapper();
        IMaterialHolder iMaterialHolder = materialHolder = storageBe instanceof IMaterialHolder ? (IMaterialHolder)((Object)storageBe) : null;
        if (storageBe instanceof ChestBlockEntity) {
            ChestBlockEntity chestBe = (ChestBlockEntity)storageBe;
            tintable = chestBe.getMainStorageWrapper();
            storageBe = chestBe.getMainChestBlockEntity();
        }
        if ((block = (state = storageBe.m_58900_()).m_60734_()) instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)block;
            v1 = storageBlock.getFacing(state);
        } else {
            v1 = effectOffsetDirection = Direction.UP;
        }
        if (PaintbrushItem.paint(player, paintbrush, soundVolume, materialHolder, (ITintable)tintable, Vec3.m_82512_((Vec3i)storageBe.m_58899_()), effectOffsetDirection, state.getSoundType((LevelReader)player.m_9236_(), storageBe.m_58899_(), null).m_56777_())) {
            WorldHelper.notifyBlockUpdate((BlockEntity)storageBe);
        }
    }

    public static boolean paint(Player player, ItemStack paintbrush, @Nullable IMaterialHolder materialHolder, ITintable tintable, Vec3 successEffectPos, Direction effectOffsetDirection, SoundEvent placeSound) {
        return PaintbrushItem.paint(player, paintbrush, 1.0f, materialHolder, tintable, successEffectPos, effectOffsetDirection, placeSound);
    }

    public static boolean paint(Player player, ItemStack paintbrush, float soundVolume, @Nullable IMaterialHolder materialHolder, ITintable tintable, Vec3 successEffectPos, Direction effectOffsetDirection, SoundEvent placeSound) {
        if (PaintbrushItem.hasBarrelMaterials(paintbrush)) {
            if (materialHolder == null || !materialHolder.canHoldMaterials()) {
                return false;
            }
            if (PaintbrushItem.applyMaterials(player, paintbrush, materialHolder, tintable)) {
                PaintbrushItem.playSoundAndParticles(player.m_9236_(), successEffectPos, soundVolume, placeSound, effectOffsetDirection);
                return true;
            }
        } else if (PaintbrushItem.setColors(player, paintbrush, tintable, materialHolder)) {
            PaintbrushItem.playSoundAndParticles(player.m_9236_(), successEffectPos, soundVolume, placeSound, effectOffsetDirection);
            return true;
        }
        return false;
    }

    public static boolean setColors(Player player, ItemStack paintbrush, ITintable tintable, @Nullable IMaterialHolder materialHolder) {
        HashMap<ResourceLocation, Integer> remainingParts = new HashMap<ResourceLocation, Integer>(PaintbrushItem.getRemainingParts(paintbrush));
        List itemHandlers = InventoryHelper.getItemHandlersFromPlayerIncludingContainers((Player)player);
        int mainColorToSet = PaintbrushItem.getMainColor(paintbrush) & 0xFFFFFF;
        int accentColorToSet = PaintbrushItem.getAccentColor(paintbrush) & 0xFFFFFF;
        int originalMainColor = tintable.getMainColor();
        int originalAccentColor = tintable.getAccentColor();
        if (originalMainColor == mainColorToSet && originalAccentColor == accentColorToSet) {
            return false;
        }
        if (!DecorationHelper.consumeDyes(mainColorToSet, accentColorToSet, remainingParts, itemHandlers, originalMainColor, originalAccentColor, true)) {
            return false;
        }
        tintable.setColors(mainColorToSet & 0xFFFFFF, accentColorToSet & 0xFFFFFF);
        if (materialHolder != null) {
            materialHolder.setMaterials(Collections.emptyMap());
        }
        DecorationHelper.consumeDyes(mainColorToSet, accentColorToSet, remainingParts, itemHandlers, originalMainColor, originalAccentColor, false);
        PaintbrushItem.setRemainingParts(paintbrush, remainingParts);
        return true;
    }

    private static boolean applyMaterials(Player player, ItemStack paintbrush, IMaterialHolder materialHolder, ITintable tintable) {
        HashMap<BarrelMaterial, ResourceLocation> materialsToApply;
        List itemHandlers = InventoryHelper.getItemHandlersFromPlayerIncludingContainers((Player)player);
        HashMap<ResourceLocation, Integer> remainingParts = new HashMap<ResourceLocation, Integer>(PaintbrushItem.getRemainingParts(paintbrush));
        HashMap<BarrelMaterial, ResourceLocation> originalMaterials = new HashMap<BarrelMaterial, ResourceLocation>(materialHolder.getMaterials());
        if (originalMaterials.equals(materialsToApply = new HashMap<BarrelMaterial, ResourceLocation>(PaintbrushItem.getBarrelMaterials(paintbrush)))) {
            return false;
        }
        BarrelBlockItem.uncompactMaterials(originalMaterials);
        if (!DecorationHelper.consumeMaterials(remainingParts, itemHandlers, originalMaterials, materialsToApply, true)) {
            return false;
        }
        DecorationHelper.consumeMaterials(remainingParts, itemHandlers, originalMaterials, materialsToApply, false);
        PaintbrushItem.setRemainingParts(paintbrush, remainingParts);
        tintable.setColors(-1, -1);
        BarrelBlockItem.compactMaterials(materialsToApply);
        materialHolder.setMaterials(materialsToApply);
        return true;
    }

    private static void playSoundAndParticles(Level level, Vec3 pos, float soundVolume, SoundEvent placeSound, Direction effectOffsetDirection) {
        level.m_6263_(null, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), placeSound, SoundSource.BLOCKS, soundVolume, 1.0f);
        if (level instanceof ServerLevel) {
            double zOffset;
            double yOffset;
            double xOffset;
            ServerLevel serverLevel = (ServerLevel)level;
            double x = pos.m_7096_() + 0.5 + (double)effectOffsetDirection.m_122429_() * 0.6;
            double y = pos.m_7098_() + 0.5 + (double)effectOffsetDirection.m_122430_() * 0.6;
            double z = pos.m_7094_() + 0.5 + (double)effectOffsetDirection.m_122431_() * 0.6;
            if (effectOffsetDirection.m_122434_().m_122478_()) {
                xOffset = 0.4;
                yOffset = 0.1;
                zOffset = 0.4;
            } else {
                xOffset = 0.1 + (double)effectOffsetDirection.m_122431_() * 0.3;
                yOffset = 0.4;
                zOffset = 0.1 + (double)effectOffsetDirection.m_122429_() * 0.3;
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 4, xOffset, yOffset, zOffset, 1.0);
        }
    }

    private static void resetBarrelMaterials(ItemStack paintbrush) {
        NBTHelper.removeTag((ItemStack)paintbrush, (String)BARREL_MATERIALS_TAG);
    }

    public static void resetMainColor(ItemStack paintbrush) {
        NBTHelper.removeTag((ItemStack)paintbrush, (String)MAIN_COLOR_TAG);
    }

    public static void resetAccentColor(ItemStack paintbrush) {
        NBTHelper.removeTag((ItemStack)paintbrush, (String)ACCENT_COLOR_TAG);
    }

    public static void setMainColor(ItemStack paintbrush, int mainColor) {
        NBTHelper.putInt((CompoundTag)paintbrush.m_41784_(), (String)MAIN_COLOR_TAG, (int)mainColor);
        PaintbrushItem.resetBarrelMaterials(paintbrush);
    }

    public static void setAccentColor(ItemStack paintbrush, int secondaryColor) {
        NBTHelper.putInt((CompoundTag)paintbrush.m_41784_(), (String)ACCENT_COLOR_TAG, (int)secondaryColor);
        PaintbrushItem.resetBarrelMaterials(paintbrush);
    }

    public static void setRemainingParts(ItemStack paintbrush, Map<ResourceLocation, Integer> remainingParts) {
        NBTHelper.putMap((CompoundTag)paintbrush.m_41784_(), (String)REMAINING_PARTS_TAG, remainingParts, ResourceLocation::toString, IntTag::m_128679_);
    }

    public static Map<ResourceLocation, Integer> getRemainingParts(ItemStack paintbrush) {
        return NBTHelper.getMap((CompoundTag)paintbrush.m_41784_(), (String)REMAINING_PARTS_TAG, ResourceLocation::new, (rl, tag) -> Optional.of(((IntTag)tag).m_7047_())).orElseGet(HashMap::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, tooltip, tooltipFlag);
        tooltip.addAll(StorageTranslationHelper.INSTANCE.getTranslatedLines(StorageTranslationHelper.INSTANCE.translItemTooltip(stack.m_41720_()), null, new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
        if (PaintbrushItem.hasBarrelMaterials(stack)) {
            tooltip.add((Component)Component.m_237115_((String)(StorageTranslationHelper.INSTANCE.translItemTooltip("paintbrush") + ".materials")).m_130940_(ChatFormatting.GRAY));
            Map<BarrelMaterial, ResourceLocation> barrelMaterials = PaintbrushItem.getBarrelMaterials(stack);
            barrelMaterials.forEach((barrelMaterial, blockName) -> BuiltInRegistries.f_256975_.m_6612_(blockName).ifPresent(block -> tooltip.add((Component)Component.m_237110_((String)(StorageTranslationHelper.INSTANCE.translItemTooltip("paintbrush") + ".material"), (Object[])new Object[]{Component.m_237115_((String)StorageTranslationHelper.INSTANCE.translGui("barrel_part." + barrelMaterial.m_7912_())), block.m_49954_().m_130940_(ChatFormatting.DARK_AQUA)}).m_130940_(ChatFormatting.GRAY))));
        }
        if (PaintbrushItem.hasMainColor(stack)) {
            int mainColor = PaintbrushItem.getMainColor(stack);
            tooltip.add((Component)Component.m_237110_((String)(StorageTranslationHelper.INSTANCE.translItemTooltip("paintbrush") + ".main_color"), (Object[])new Object[]{Component.m_237113_((String)ColorHelper.getHexColor((int)mainColor)).m_130948_(Style.f_131099_.m_178520_(mainColor))}).m_130940_(ChatFormatting.GRAY));
        }
        if (PaintbrushItem.hasAccentColor(stack)) {
            int accentColor = PaintbrushItem.getAccentColor(stack);
            tooltip.add((Component)Component.m_237110_((String)(StorageTranslationHelper.INSTANCE.translItemTooltip("paintbrush") + ".accent_color"), (Object[])new Object[]{Component.m_237113_((String)ColorHelper.getHexColor((int)accentColor)).m_130948_(Style.f_131099_.m_178520_(accentColor))}).m_130940_(ChatFormatting.GRAY));
        }
    }

    private static boolean hasMainColor(ItemStack paintbrush) {
        return NBTHelper.hasTag((ItemStack)paintbrush, (String)MAIN_COLOR_TAG);
    }

    private static boolean hasAccentColor(ItemStack paintbrush) {
        return NBTHelper.hasTag((ItemStack)paintbrush, (String)ACCENT_COLOR_TAG);
    }

    private static boolean hasBarrelMaterials(ItemStack paintbrush) {
        return NBTHelper.hasTag((ItemStack)paintbrush, (String)BARREL_MATERIALS_TAG);
    }

    public static int getMainColor(ItemStack paintbrush) {
        return NBTHelper.getInt((ItemStack)paintbrush, (String)MAIN_COLOR_TAG).orElse(-1);
    }

    public static int getAccentColor(ItemStack paintbrush) {
        return NBTHelper.getInt((ItemStack)paintbrush, (String)ACCENT_COLOR_TAG).orElse(-1);
    }

    public static Map<BarrelMaterial, ResourceLocation> getBarrelMaterials(ItemStack paintbrush) {
        return NBTHelper.getMap((CompoundTag)paintbrush.m_41784_(), (String)BARREL_MATERIALS_TAG, BarrelMaterial::fromName, (bm, tag) -> Optional.of(new ResourceLocation(tag.m_7916_()))).orElse(Map.of());
    }

    public record ItemRequirements(List<ItemStack> itemsPresent, List<ItemStack> itemsMissing) {
    }
}

