/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.unusual.blockfactorysbosses.LargeSwordItemRenderer;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModItems;

public class LargeSwordItem
extends SwordItem {
    public static final Map<String, AnimationState> IDLE_STATES = new WeakHashMap<String, AnimationState>();
    public static final Map<String, AnimationState> SWING_STATES = new WeakHashMap<String, AnimationState>();
    public static final Map<ItemStack, Integer> IS_MINING = new WeakHashMap<ItemStack, Integer>();

    public LargeSwordItem() {
        super(new Tier(){

            public int m_6609_() {
                return 400;
            }

            public float m_6624_() {
                return 4.0f;
            }

            public float m_6631_() {
                return 0.0f;
            }

            public int m_6604_() {
                return 0;
            }

            public int m_6601_() {
                return 2;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BlockFactorysBossesModItems.ANCIENT_IRON_INGOT.get())});
            }
        }, 11, -3.3f, new Item.Properties());
    }

    public float m_8102_(ItemStack itemstack, BlockState blockstate) {
        IS_MINING.put(itemstack, 5);
        if (itemstack.m_41784_().m_128459_("swing_animtime") == 0.0) {
            return 1.0f;
        }
        return 0.0f;
    }

    public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        double swing_animtime;
        super.m_6883_(itemstack, world, entity, slot, selected);
        if (itemstack.m_41784_().m_128461_("itemKey").isEmpty()) {
            itemstack.m_41784_().m_128359_("itemKey", UUID.randomUUID().toString());
        }
        String key = itemstack.m_41784_().m_128461_("itemKey");
        int is_mining = IS_MINING.computeIfAbsent(itemstack, s -> 0);
        if (is_mining > 0) {
            IS_MINING.put(itemstack, is_mining - 1);
        }
        if ((swing_animtime = itemstack.m_41784_().m_128459_("swing_animtime")) > 0.0) {
            itemstack.m_41784_().m_128347_("swing_animtime", swing_animtime - 1.0);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity) {
        double swing_animtime;
        boolean retval = super.onEntitySwing(itemstack, entity);
        int is_mining = IS_MINING.computeIfAbsent(itemstack, s -> 0);
        if (is_mining == 0 && (swing_animtime = itemstack.m_41784_().m_128459_("swing_animtime")) == 0.0 && entity instanceof Player) {
            Player plr = (Player)entity;
            this.playSound(plr, (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation("block_factorys_bosses:large_sword_swing")));
            itemstack.m_41784_().m_128359_("itemKey", UUID.randomUUID().toString());
            itemstack.m_41784_().m_128347_("swing_animtime", 14.0);
        }
        return retval;
    }

    @SubscribeEvent
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private LargeSwordItemRenderer rendererInstance;

            @OnlyIn(value=Dist.CLIENT)
            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                int is_mining = IS_MINING.computeIfAbsent(player.m_21205_(), s -> 0);
                double swing_animtime = player.m_21205_().m_41784_().m_128459_("swing_animtime");
                if (is_mining == 0 && swing_animtime > 0.0) {
                    int i = arm == HumanoidArm.RIGHT ? 1 : -1;
                    poseStack.m_252880_((float)i * 0.56f, -0.52f, -0.72f);
                    if (player.m_21211_() == itemInHand) {
                        poseStack.m_85837_(0.05, 0.05, 0.05);
                    }
                    return true;
                }
                return false;
            }

            @OnlyIn(value=Dist.CLIENT)
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.rendererInstance == null) {
                    this.rendererInstance = new LargeSwordItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
                }
                return this.rendererInstance;
            }
        });
    }

    protected void playSound(Player player, SoundEvent soundEvent) {
        player.m_5496_(soundEvent, 1.0f, 1.0f);
    }
}

