/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.api.ChopEvent;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.util.TickUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="treechop", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MultiMine {
    private static Long lastChopTick = TickUtil.NEVER;
    private static final Set<BlockPos> lastChops = new HashSet<BlockPos>();

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        if (ConfigHandler.COMMON.compatForMultiMine.get().booleanValue() && ModList.get().isLoaded("multimine")) {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, MultiMine::onChop);
        }
    }

    public static void onChop(ChopEvent.StartChopEvent event) {
        BlockPos pos = event.getChoppedBlockPos();
        long gameTick = event.getLevel().m_46467_();
        if (lastChopTick == gameTick) {
            if (lastChops.contains(pos)) {
                event.setCanceled(true);
                Object object = event.getTrigger();
                if (object instanceof BlockEvent.BreakEvent) {
                    BlockEvent.BreakEvent breakEvent = (BlockEvent.BreakEvent)object;
                    breakEvent.setCanceled(true);
                }
            }
        } else {
            lastChops.clear();
            lastChopTick = gameTick;
        }
        lastChops.add(pos);
    }
}

