/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.TreeChop;
import ht.treechop.TreeChopException;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.api.IChoppingItem;
import ht.treechop.api.IFellableBlock;
import ht.treechop.api.IStrippableBlock;
import ht.treechop.api.IThwackableBlock;
import ht.treechop.api.ITreeBlock;
import ht.treechop.api.TreeData;
import ht.treechop.api.TreeDetectorBuilder;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.Chop;
import ht.treechop.common.chop.ChopDataImpl;
import ht.treechop.common.chop.ChopResult;
import ht.treechop.common.chop.ChopTreeResult;
import ht.treechop.common.chop.FellTreeResult;
import ht.treechop.common.config.ChopCounting;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.Lazy;
import ht.treechop.common.config.TreeLeavesBehavior;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.util.AxeAccessor;
import ht.treechop.common.util.BlockUtil;
import ht.treechop.common.util.ClassUtil;
import ht.treechop.server.Server;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class ChopUtil {
    private static final Lazy<ITreeBlock> defaultDetector = new Lazy<ITreeBlock>(ConfigHandler.RELOAD, () -> new TreeDetectorBuilder().build());

    public static boolean isBlockALog(Level level, BlockPos pos) {
        return ChopUtil.isBlockALog(level, pos, level.m_8055_(pos));
    }

    public static boolean isBlockALog(Level level, BlockPos pos, BlockState blockState) {
        return ChopUtil.isBlockChoppable((BlockGetter)level, pos, blockState);
    }

    public static boolean isBlockChoppable(Level level, BlockPos pos) {
        return ChopUtil.isBlockChoppable((BlockGetter)level, pos, level.m_8055_(pos));
    }

    public static boolean isBlockChoppable(BlockGetter level, BlockPos pos, BlockState blockState) {
        return ClassUtil.getChoppableBlock(level, pos, blockState) != null;
    }

    public static boolean isBlockLeaves(Level level, BlockPos pos, BlockState state) {
        return ChopUtil.isBlockLeaves(state);
    }

    public static boolean isBlockLeaves(Level level, BlockPos pos) {
        return ChopUtil.isBlockLeaves(level.m_8055_(pos));
    }

    public static boolean isBlockLeaves(BlockState blockState) {
        TreeLeavesBehavior behavior = ConfigHandler.COMMON.leavesBlocks.get().get(blockState.m_60734_());
        if (behavior != null) {
            return behavior.isLeaves(blockState);
        }
        return false;
    }

    public static boolean enoughChopsToFell(int chops, double support) {
        return ChopCounting.calculate((int)support) <= chops;
    }

    public static int numChopsToFell(double support) {
        return ChopCounting.calculate(Math.max(1, Double.valueOf(support).intValue()));
    }

    public static int numChopsToFell(Level level, Stream<BlockPos> logs) {
        double support = logs.map(pos -> ChopUtil.getSupportFactor(level, pos)).reduce(Double::sum).orElse(1.0);
        return ChopUtil.numChopsToFell(support);
    }

    public static Optional<Double> getSupportFactor(Level level, Stream<BlockPos> blocks) {
        return blocks.map(pos -> ChopUtil.getSupportFactor(level, pos)).reduce(Double::sum);
    }

    public static double getSupportFactor(Level level, BlockPos pos) {
        return ChopUtil.getSupportFactor(level, pos, level.m_8055_(pos));
    }

    private static double getSupportFactor(Level level, BlockPos pos, BlockState state) {
        double d;
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof IFellableBlock) {
            IFellableBlock block2 = (IFellableBlock)block;
            d = block2.getSupportFactor((BlockGetter)level, pos, state);
        } else {
            d = 1.0;
        }
        return d;
    }

    public static ChopResult getChopResult(Level level, BlockPos origin, int numChops, boolean fellIfPossible, boolean mustHaveLeaves, boolean breakLeaves, TreeData tree) {
        return fellIfPossible ? ChopUtil.getChopResult(level, origin, numChops, mustHaveLeaves, breakLeaves, tree) : ChopUtil.tryToChopWithoutFelling(level, origin, numChops);
    }

    private static ChopResult getChopResult(Level level, BlockPos origin, int numChops, boolean mustHaveLeaves, boolean breakLeaves, TreeData tree) {
        if (tree.isAProperTree(mustHaveLeaves)) {
            return ChopUtil.getChopResult(level, origin, tree, numChops, breakLeaves);
        }
        return ChopResult.IGNORED;
    }

    public static TreeData getTree(Level level, BlockPos origin) {
        ITreeBlock detector = ClassUtil.getTreeBlock(ChopUtil.getLogBlock(level, origin));
        if (detector == null) {
            detector = defaultDetector.get();
        }
        TreeData tree = detector.getTree(level, origin);
        return TreeChop.platform.detectTreeEvent(level, null, origin, level.m_8055_(origin), tree);
    }

    private static ChopResult getChopResult(Level level, BlockPos origin, TreeData tree, int numChops, boolean breakLeaves) {
        if (tree.streamLogs().findFirst().isEmpty()) {
            return ChopResult.IGNORED;
        }
        if (tree.readyToFell(tree.getChops() + numChops)) {
            int numChopsNeeded = Math.min(10, Math.max(0, tree.numChopsNeededToFell() - tree.getChops()));
            return new FellTreeResult(level, tree, breakLeaves, tree.chop(origin, numChopsNeeded));
        }
        return new ChopTreeResult(level, tree.chop(origin, numChops));
    }

    public static int getMaxNumChops(Level level, BlockPos blockPos, BlockState blockState) {
        IChoppableBlock choppableBlock = ClassUtil.getChoppableBlock((BlockGetter)level, blockPos, blockState);
        return choppableBlock != null ? choppableBlock.getMaxNumChops((BlockGetter)level, blockPos, blockState) : 0;
    }

    public static int getNumChops(Level level, BlockPos pos) {
        return ChopUtil.getNumChops(level, pos, level.m_8055_(pos));
    }

    public static int getNumChops(Level level, BlockPos pos, BlockState blockState) {
        int n;
        Block block = blockState.m_60734_();
        if (block instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)block;
            n = choppableBlock.getNumChops((BlockGetter)level, pos, blockState);
        } else {
            n = 0;
        }
        return n;
    }

    public static int getNumChops(Level level, Set<BlockPos> positions) {
        return positions.stream().map(pos -> Pair.of((Object)pos, (Object)level.m_8055_(pos))).map(posAndblockState -> {
            Integer n;
            Block patt6743$temp = ((BlockState)posAndblockState.getRight()).m_60734_();
            if (patt6743$temp instanceof IChoppableBlock) {
                IChoppableBlock choppableBlock = (IChoppableBlock)patt6743$temp;
                n = choppableBlock.getNumChops((BlockGetter)level, (BlockPos)posAndblockState.getLeft(), (BlockState)posAndblockState.getRight());
            } else {
                n = 0;
            }
            return n;
        }).reduce(Integer::sum).orElse(0);
    }

    private static ChopResult tryToChopWithoutFelling(Level level, BlockPos blockPos, int numChops) {
        return ChopUtil.isBlockChoppable(level, blockPos) ? new ChopTreeResult(level, Collections.singletonList(new Chop(blockPos, numChops))) : ChopResult.IGNORED;
    }

    public static int blockDistance(BlockPos a, BlockPos b) {
        return a.m_123333_((Vec3i)b);
    }

    public static int horizontalBlockDistance(BlockPos a, BlockPos b) {
        return new Vec3i(a.m_123341_(), 0, a.m_123343_()).m_123333_(new Vec3i(b.m_123341_(), 0, b.m_123343_()));
    }

    public static boolean canChopWithTool(Player player, Level level, BlockPos pos) {
        return ChopUtil.canChopWithTool(player, player.m_21205_(), level, pos, level.m_8055_(pos));
    }

    public static boolean canChopWithTool(Player player, ItemStack tool, Level level, BlockPos pos, BlockState blockState) {
        return !((Boolean)ConfigHandler.COMMON.mustUseCorrectToolForDrops.get() != false && blockState.m_60834_() && !tool.m_41735_(blockState) || (Boolean)ConfigHandler.COMMON.mustUseFastBreakingTool.get() != false && !(tool.m_41691_(blockState) > 1.0f) || !ConfigHandler.canChopWithTool(player, tool, level, pos, blockState));
    }

    public static int getNumChopsByTool(ItemStack tool, BlockState blockState) {
        IChoppingItem choppingItem = ClassUtil.getChoppingItem(tool.m_41720_());
        if (choppingItem != null) {
            return choppingItem.getNumChops(tool, blockState);
        }
        return 1;
    }

    public static boolean playerWantsToChop(Player player, ChopSettings chopSettings) {
        if (((Boolean)ConfigHandler.COMMON.enabled.get()).booleanValue() && (player != null && !player.m_7500_() || chopSettings.getChopInCreativeMode())) {
            return chopSettings.getChoppingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeChopBehavior((Entity)player);
        }
        return false;
    }

    public static boolean playerWantsToFell(Player player, ChopSettings chopSettings) {
        return chopSettings.getFellingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeFellBehavior((Entity)player);
    }

    public static boolean chop(ServerPlayer agent, ServerLevel level, BlockPos pos, BlockState blockState, ItemStack tool, Object trigger) throws TreeChopException {
        ChopSettings chopSettings = Server.instance().getPlayerChopData((Player)agent).getSettings();
        if (ChopUtil.playerWantsToChop((Player)agent, chopSettings)) {
            int numChops = ChopUtil.getNumChopsByTool(tool, blockState);
            boolean felling = ChopUtil.playerWantsToFell((Player)agent, chopSettings);
            boolean treesMustHaveLeaves = chopSettings.getTreesMustHaveLeaves();
            return ChopUtil.chop(agent, level, pos, blockState, tool, trigger, numChops, felling, treesMustHaveLeaves);
        }
        return false;
    }

    public static boolean chop(ServerPlayer agent, ServerLevel level, BlockPos pos, BlockState blockState, ItemStack tool, Object trigger, int numChops, boolean felling, boolean treesMustHaveLeaves) throws TreeChopException {
        try {
            return ChopUtil.chopUnsafe(agent, level, pos, blockState, tool, trigger, numChops, felling, treesMustHaveLeaves);
        }
        catch (Exception e) {
            throw new TreeChopException(String.format("Parameters: %s, %s, %s, %s, %s, %s, %s, %s, %s", agent, level, pos, blockState, tool, trigger, numChops, felling, treesMustHaveLeaves), e);
        }
    }

    public static boolean chopUnsafe(ServerPlayer agent, ServerLevel level, BlockPos pos, BlockState blockState, ItemStack tool, Object trigger, int numChops, boolean felling, boolean treesMustHaveLeaves) {
        if (!ChopUtil.isBlockChoppable((BlockGetter)level, pos, blockState) || !ChopUtil.canChopWithTool((Player)agent, tool, (Level)level, pos, blockState)) {
            return false;
        }
        TreeData tree = felling ? ChopUtil.getTree((Level)level, pos) : null;
        ChopDataImpl chopData = new ChopDataImpl(numChops, felling, tree);
        boolean doChop = TreeChop.platform.startChopEvent(agent, level, pos, blockState, chopData, trigger);
        if (!doChop) {
            return false;
        }
        ChopResult chopResult = ChopUtil.getChopResult((Level)level, pos, chopData.getNumChops(), chopData.getFelling(), treesMustHaveLeaves, (Boolean)ConfigHandler.COMMON.breakLeaves.get(), tree);
        if (chopResult != ChopResult.IGNORED) {
            chopResult.apply(pos, agent, tool);
            TreeChop.platform.finishChopEvent(agent, level, pos, blockState, chopData, chopResult);
            tool.m_41686_((Level)level, blockState, pos, (Player)agent);
            boolean felled = chopResult instanceof FellTreeResult;
            if (!felled) {
                ChopUtil.thwack((Player)agent, (Level)level, pos, blockState);
            }
            return !felled;
        }
        return false;
    }

    public static void thwack(Player thwacker, Level level, BlockPos pos, BlockState state) {
        IThwackableBlock thwackable = ClassUtil.getThwackableBlock(state.m_60734_());
        if (thwackable != null) {
            thwackable.thwack(thwacker, level, pos, state);
        } else {
            float volume = 0.3f;
            float pitch = 1.0f;
            level.m_5594_(thwacker, pos, TreeChop.CHOP_WOOD_EVENT.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
            level.m_142052_(pos, state);
        }
    }

    public static BlockState getStrippedState(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        return ChopUtil.getStrippedState(level, pos, state, state);
    }

    public static BlockState getStrippedState(BlockAndTintGetter level, BlockPos pos, BlockState state, BlockState fallback) {
        BlockState strippedState;
        BlockState blockState = strippedState = AxeAccessor.isStripped(state.m_60734_()) ? state : AxeAccessor.getStripped(state);
        if (strippedState == null && (strippedState = TreeChop.platform.getStrippedState(level, pos, state)) == null) {
            IStrippableBlock strippableBlock = ClassUtil.getStrippableBlock(state.m_60734_());
            if (strippableBlock != null) {
                return strippableBlock.getStrippedState((BlockGetter)level, pos, state);
            }
            strippedState = ConfigHandler.inferredStrippedStates.get().get(state.m_60734_());
        }
        return strippedState != null ? BlockUtil.copyStateProperties(strippedState, state) : fallback;
    }

    public static BlockState getLogState(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)blockEntity;
            return entity.getOriginalState();
        }
        return level.m_8055_(pos);
    }

    public static Block getLogBlock(Level level, BlockPos pos) {
        return ChopUtil.getLogBlock(level, pos, level.m_8055_(pos));
    }

    public static Block getLogBlock(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)blockEntity;
            return entity.getOriginalState().m_60734_();
        }
        return state.m_60734_();
    }
}

