/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.spell;

import alexthw.not_enough_glyphs.common.glyphs.MethodTrail;
import alexthw.not_enough_glyphs.init.Registry;
import com.hollingsworth.arsnouveau.api.block.IPrismaticBlock;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class TrailingProjectile
extends EntityProjectileSpell {
    public static final EntityDataAccessor<Integer> DELAY = SynchedEntityData.m_135353_(TrailingProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> AOE = SynchedEntityData.m_135353_(TrailingProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public int maxProcs = 20;
    public int totalProcs;

    public TrailingProjectile(EntityType<? extends EntityProjectileSpell> entityType, Level world) {
        super(entityType, world);
    }

    public TrailingProjectile(Level world, SpellResolver resolver) {
        super((EntityType)Registry.TRAILING_PROJECTILE.get(), world, resolver);
    }

    public int getExpirationTime() {
        return MethodTrail.INSTANCE.getProjectileLifespan() * 20;
    }

    public EntityType<?> m_6095_() {
        return (EntityType)Registry.TRAILING_PROJECTILE.get();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.age > 5 && this.totalProcs < this.maxProcs && this.age % Math.max(2, 12 - 2 * this.getDelay()) == 0) {
            this.castSpells();
        }
    }

    public void traceAnyHit(@Nullable HitResult rayTraceResult, Vec3 thisPosition, Vec3 nextPosition) {
        EntityHitResult entityraytraceresult;
        if (rayTraceResult != null && rayTraceResult.m_6662_() != HitResult.Type.MISS) {
            nextPosition = rayTraceResult.m_82450_();
        }
        if ((entityraytraceresult = this.findHitEntity(thisPosition, nextPosition)) != null) {
            rayTraceResult = entityraytraceresult;
        }
        if (rayTraceResult != null && rayTraceResult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)rayTraceResult)) {
            Level level = this.m_9236_();
            if (!level.f_46443_ && rayTraceResult instanceof BlockHitResult) {
                BlockHitResult blockRaytraceResult = (BlockHitResult)rayTraceResult;
                if (!this.m_213877_() && !this.hitList.contains(blockRaytraceResult.m_82425_())) {
                    BlockState state = level.m_8055_(blockRaytraceResult.m_82425_());
                    Block block = state.m_60734_();
                    if (block instanceof IPrismaticBlock) {
                        IPrismaticBlock prismaticBlock = (IPrismaticBlock)block;
                        prismaticBlock.onHit((ServerLevel)level, blockRaytraceResult.m_82425_(), (EntityProjectileSpell)this);
                        return;
                    }
                    if (state.m_204336_(BlockTags.f_13075_)) {
                        state.m_60734_().m_7892_(state, level, blockRaytraceResult.m_82425_(), (Entity)this);
                        return;
                    }
                    if (state.m_60734_() instanceof TargetBlock) {
                        this.m_8060_(blockRaytraceResult);
                    }
                    this.attemptRemoval();
                    this.hitList.add(blockRaytraceResult.m_82425_());
                }
            }
            this.f_19812_ = true;
        }
        if (rayTraceResult != null && rayTraceResult.m_6662_() == HitResult.Type.MISS && rayTraceResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
            if (this.canTraversePortals()) {
                ((PortalBlock)BlockRegistry.PORTAL_BLOCK.get()).m_5581_(this.m_9236_(), this.m_9236_().m_8055_(BlockPos.m_274446_((Position)rayTraceResult.m_82450_())), blockHitResult, (Projectile)this);
            }
        }
    }

    protected void attemptRemoval() {
        ++this.totalProcs;
        super.attemptRemoval();
    }

    public void castSpells() {
        float aoe = this.getAoe();
        int flatAoe = Math.round(aoe);
        if (!this.m_9236_().f_46443_) {
            if (this.isSensitive()) {
                int counter = 0;
                for (BlockPos p : BlockPos.m_121940_((BlockPos)this.m_20183_().m_122030_(flatAoe).m_122013_(flatAoe), (BlockPos)this.m_20183_().m_122025_(flatAoe).m_122020_(flatAoe))) {
                    this.spellResolver.onResolveEffect(this.m_9236_(), (HitResult)new BlockHitResult(Vec3.m_82512_((Vec3i)p), Direction.DOWN, p, true));
                    ++counter;
                }
                if (counter > 0) {
                    this.totalProcs += Math.max(1, (int)((float)counter / (10.0f + this.getAoe())));
                }
            } else {
                int i = 0;
                for (Entity entity : this.m_9236_().m_45933_(null, new AABB(this.m_20183_()).m_82400_((double)this.getAoe()))) {
                    if (entity.equals((Object)this) || entity.m_6095_().m_204039_(EntityTags.LINGERING_BLACKLIST)) continue;
                    this.spellResolver.onResolveEffect(this.m_9236_(), (HitResult)new EntityHitResult(entity));
                    if (++i <= 5) continue;
                    break;
                }
                this.totalProcs += i;
            }
            if (this.totalProcs >= this.maxProcs) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        } else {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235902_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20184_().m_7096_(), this.m_20184_().m_7098_(), this.m_20184_().m_7094_());
        }
    }

    public int getDelay() {
        return (Integer)this.f_19804_.m_135370_(DELAY);
    }

    public void setDelay(int time) {
        this.f_19804_.m_135381_(DELAY, (Object)time);
    }

    public void setAoe(double aoe) {
        this.f_19804_.m_135381_(AOE, (Object)Float.valueOf((float)aoe));
    }

    public float getAoe() {
        return (float)(this.isSensitive() ? 0 : 2) + ((Float)this.f_19804_.m_135370_(AOE)).floatValue();
    }

    public boolean isSensitive() {
        return this.numSensitive > 0;
    }

    public int getParticleDelay() {
        return 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DELAY, (Object)0);
        this.f_19804_.m_135372_(AOE, (Object)Float.valueOf(0.0f));
    }
}

