/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs.filters;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractFilter;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import java.util.Collections;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEffectFilter
extends AbstractFilter {
    private boolean inverted = false;

    public AbstractEffectFilter(ResourceLocation tag, String description) {
        super(tag, description);
    }

    public AbstractEffectFilter inverted() {
        this.inverted = !this.inverted;
        return this;
    }

    public boolean shouldAffect(HitResult rayTraceResult, Level level) {
        return this.inverted != super.shouldAffect(rayTraceResult, level);
    }

    public Integer getTypeIndex() {
        return 15;
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (!this.shouldResolveOnEntity(rayTraceResult, world)) {
            spellContext.setCanceled(true);
        }
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (!this.shouldResolveOnBlock(rayTraceResult, world)) {
            spellContext.setCanceled(true);
        }
    }

    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public int getDefaultManaCost() {
        return 0;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return Collections.emptySet();
    }

    public boolean shouldResolveOnBlock(BlockHitResult target, Level level) {
        return false;
    }

    public boolean shouldResolveOnEntity(EntityHitResult target, Level level) {
        return false;
    }
}

