/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public final class Utils {
    private Utils() {
    }

    public static <E extends Enum<E>> E getEnumValue(Class<E> clazz, int ordinal) {
        Enum[] values = (Enum[])Objects.requireNonNull(clazz, "clazz").getEnumConstants();
        return (E)values[ordinal < 0 || ordinal >= values.length ? 0 : ordinal];
    }

    public static Component formatRecipeTooltip(String key) {
        return Utils.formatRecipeTooltipValue(Language.m_128107_().m_6834_(key));
    }

    private static Component formatRecipeTooltipValue(String value) {
        return Component.m_237110_((String)"recipe.ingredient.tooltip", (Object[])new Object[]{value});
    }

    public static boolean impliesNbt(@Nullable Tag antecedent, @Nullable Tag consequent) {
        if (antecedent == consequent) {
            return true;
        }
        if (antecedent == null != (consequent == null)) {
            return false;
        }
        if (!antecedent.getClass().equals(consequent.getClass())) {
            return false;
        }
        if (antecedent instanceof CompoundTag) {
            for (String key : ((CompoundTag)antecedent).m_128431_()) {
                if (Utils.impliesNbt(((CompoundTag)antecedent).m_128423_(key), ((CompoundTag)consequent).m_128423_(key))) continue;
                return false;
            }
            return true;
        }
        return antecedent.equals(consequent);
    }
}

