/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener.accessor;

import java.util.UUID;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.fastener.EntityFastener;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public abstract class EntityFastenerAccessor<E extends Entity>
implements FastenerAccessor {
    private final Class<? extends E> entityClass;
    private UUID uuid;
    @Nullable
    private E entity;
    @Nullable
    private Vec3 pos;

    public EntityFastenerAccessor(Class<? extends E> entityClass) {
        this(entityClass, (UUID)null);
    }

    public EntityFastenerAccessor(Class<? extends E> entityClass, EntityFastener<E> fastener) {
        this(entityClass, fastener.getEntity().m_20148_());
        this.entity = fastener.getEntity();
        this.pos = this.entity.m_20182_();
    }

    public EntityFastenerAccessor(Class<? extends E> entityClass, UUID uuid) {
        this.entityClass = entityClass;
        this.uuid = uuid;
    }

    @Override
    public LazyOptional<Fastener<?>> get(Level world, boolean load) {
        block3: {
            block4: {
                if (this.entity != null) break block3;
                if (!(world instanceof ServerLevel)) break block4;
                Entity e = ((ServerLevel)world).m_8791_(this.uuid);
                if (!this.entityClass.isInstance(e)) break block3;
                this.entity = (Entity)this.entityClass.cast(e);
                break block3;
            }
            if (this.pos != null) {
                for (Entity entity : world.m_45976_(this.entityClass, new AABB(this.pos.m_82492_(1.0, 1.0, 1.0), this.pos.m_82520_(1.0, 1.0, 1.0)))) {
                    if (!this.uuid.equals(entity.m_20148_())) continue;
                    this.entity = entity;
                    break;
                }
            }
        }
        if (this.entity != null && this.entity.m_9236_() == world) {
            this.pos = this.entity.m_20182_();
            return this.entity.getCapability(CapabilityHandler.FASTENER_CAP);
        }
        return LazyOptional.empty();
    }

    @Override
    public boolean isGone(Level world) {
        return !world.m_5776_() && this.entity != null && (!this.entity.getCapability(CapabilityHandler.FASTENER_CAP).isPresent() || this.entity.m_9236_() != world);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EntityFastenerAccessor) {
            return this.uuid.equals(((EntityFastenerAccessor)obj).uuid);
        }
        return false;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("UUID", this.uuid);
        if (this.pos != null) {
            ListTag pos = new ListTag();
            pos.add((Object)DoubleTag.m_128500_((double)this.pos.f_82479_));
            pos.add((Object)DoubleTag.m_128500_((double)this.pos.f_82480_));
            pos.add((Object)DoubleTag.m_128500_((double)this.pos.f_82481_));
            tag.m_128365_("Pos", (Tag)pos);
        }
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.uuid = tag.m_128342_("UUID");
        if (tag.m_128425_("Pos", 9)) {
            ListTag pos = tag.m_128437_("Pos", 6);
            this.pos = new Vec3(pos.m_128772_(0), pos.m_128772_(1), pos.m_128772_(2));
        } else {
            this.pos = null;
        }
        this.entity = null;
    }
}

