/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.util.UUID;
import javax.annotation.Nullable;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.server.collision.Collidable;
import me.paulf.fairylights.server.collision.CollidableList;
import me.paulf.fairylights.server.collision.FeatureCollisionTree;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.connection.PlayerAction;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.fastener.FenceFastener;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import me.paulf.fairylights.server.feature.Feature;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.server.item.ConnectionItem;
import me.paulf.fairylights.server.net.serverbound.InteractionConnectionMessage;
import me.paulf.fairylights.server.sound.FLSounds;
import me.paulf.fairylights.util.Catenary;
import me.paulf.fairylights.util.CubicBezier;
import me.paulf.fairylights.util.Curve;
import me.paulf.fairylights.util.Curve3d;
import me.paulf.fairylights.util.NBTSerializable;
import me.paulf.fairylights.util.Utils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class Connection
implements NBTSerializable {
    public static final int MAX_LENGTH = 32;
    public static final double PULL_RANGE = 5.0;
    public static final FeatureType CORD_FEATURE = FeatureType.register("cord");
    private static final CubicBezier SLACK_CURVE = new CubicBezier(0.495f, 0.505f, 0.495f, 0.505f);
    private static final float MAX_SLACK = 3.0f;
    private final ConnectionType<?> type;
    protected final Fastener<?> fastener;
    private final UUID uuid;
    private FastenerAccessor destination;
    @Nullable
    private FastenerAccessor prevDestination;
    protected Level world;
    @Nullable
    private Curve catenary;
    @Nullable
    protected Curve prevCatenary;
    protected float slack = 1.0f;
    private Collidable collision = Collidable.empty();
    private boolean updateCatenary;
    private int prevStretchStage;
    private boolean removed;
    private boolean drop;

    public Connection(ConnectionType<?> type, Level world, Fastener<?> fastener, UUID uuid) {
        this.type = type;
        this.world = world;
        this.fastener = fastener;
        this.uuid = uuid;
        this.computeCatenary();
    }

    public ConnectionType<?> getType() {
        return this.type;
    }

    @Nullable
    public final Curve getCatenary() {
        return this.catenary;
    }

    @Nullable
    public final Curve getPrevCatenary() {
        return this.prevCatenary == null ? this.catenary : this.prevCatenary;
    }

    public void setWorld(Level world) {
        this.world = world;
    }

    public final Level getWorld() {
        return this.world;
    }

    public final Collidable getCollision() {
        return this.collision;
    }

    public final Fastener<?> getFastener() {
        return this.fastener;
    }

    public final UUID getUUID() {
        return this.uuid;
    }

    public final void setDestination(Fastener<?> destination) {
        this.prevDestination = this.destination;
        this.destination = destination.createAccessor();
        this.computeCatenary();
    }

    public final FastenerAccessor getDestination() {
        return this.destination;
    }

    public boolean isDestination(FastenerAccessor location) {
        return this.destination.equals(location);
    }

    public void setDrop() {
        this.drop = true;
    }

    public void noDrop() {
        this.drop = false;
    }

    public boolean shouldDrop() {
        return this.drop;
    }

    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack((ItemLike)this.getType().getItem());
        CompoundTag tagCompound = this.serializeLogic();
        if (!tagCompound.m_128456_()) {
            stack.m_41751_(tagCompound);
        }
        return stack;
    }

    public float getRadius() {
        return 0.0625f;
    }

    public final boolean isDynamic() {
        return this.fastener.isMoving() || this.destination.get(this.world, false).filter(Fastener::isMoving).isPresent();
    }

    public final boolean isModifiable(Player player) {
        return this.world.m_7966_(player, this.fastener.getPos());
    }

    public final void remove() {
        if (!this.removed) {
            this.removed = true;
            this.onRemove();
        }
    }

    public final boolean isRemoved() {
        return this.removed;
    }

    public void computeCatenary() {
        this.updateCatenary = true;
    }

    public void processClientAction(Player player, PlayerAction action, Intersection intersection) {
        FairyLights.NETWORK.sendToServer((Object)new InteractionConnectionMessage(this, action, intersection));
    }

    public void disconnect(Player player, Vec3 hit) {
        this.destination.get(this.world).ifPresent(f -> this.disconnect((Fastener<?>)f, hit));
    }

    private void disconnect(Fastener<?> destinationFastener, Vec3 hit) {
        this.fastener.removeConnection(this);
        destinationFastener.removeConnection(this.uuid);
        if (this.shouldDrop()) {
            ItemStack stack = this.getItemStack();
            ItemEntity item = new ItemEntity(this.world, hit.f_82479_, hit.f_82480_, hit.f_82481_, stack);
            float scale = 0.05f;
            item.m_20334_(this.world.f_46441_.m_188583_() * (double)0.05f, this.world.f_46441_.m_188583_() * (double)0.05f + (double)0.2f, this.world.f_46441_.m_188583_() * (double)0.05f);
            this.world.m_7967_((Entity)item);
        }
        this.world.m_6263_(null, hit.f_82479_, hit.f_82480_, hit.f_82481_, (SoundEvent)FLSounds.CORD_DISCONNECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public boolean reconnect(Fastener<?> destination) {
        return this.fastener.reconnect(this.world, this, destination);
    }

    public boolean interact(Player player, Vec3 hit, FeatureType featureType, int feature, ItemStack heldStack, InteractionHand hand) {
        Item item = heldStack.m_41720_();
        if (item instanceof ConnectionItem && !this.matches(heldStack)) {
            return this.replace(player, hit, heldStack);
        }
        if (heldStack.m_204117_(Tags.Items.STRING)) {
            return this.slacken(hit, heldStack, 0.2f);
        }
        if (heldStack.m_150930_(Items.f_42398_)) {
            return this.slacken(hit, heldStack, -0.2f);
        }
        return false;
    }

    public boolean matches(ItemStack stack) {
        if (this.getType().getItem().equals(stack.m_41720_())) {
            CompoundTag tag = stack.m_41783_();
            return tag == null || Utils.impliesNbt((Tag)this.serializeLogic(), (Tag)tag);
        }
        return false;
    }

    private boolean replace(Player player, Vec3 hit, ItemStack heldStack) {
        return this.destination.get(this.world).map(dest -> {
            this.fastener.removeConnection(this);
            dest.removeConnection(this.uuid);
            if (this.shouldDrop()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.getItemStack());
            }
            CompoundTag data = heldStack.m_41783_();
            ConnectionType<?> type = ((ConnectionItem)heldStack.m_41720_()).getConnectionType();
            Connection conn = this.fastener.connect(this.world, (Fastener<?>)dest, type, data == null ? new CompoundTag() : data, true);
            conn.slack = this.slack;
            conn.onConnect(player.m_9236_(), player, heldStack);
            heldStack.m_41774_(1);
            this.world.m_6263_(null, hit.f_82479_, hit.f_82480_, hit.f_82481_, (SoundEvent)FLSounds.CORD_CONNECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }).orElse(false);
    }

    private boolean slacken(Vec3 hit, ItemStack heldStack, float amount) {
        if (this.slack <= 0.0f && amount < 0.0f || this.slack >= 3.0f && amount > 0.0f) {
            return true;
        }
        this.slack = Mth.m_14036_((float)(this.slack + amount), (float)0.0f, (float)3.0f);
        if (this.slack < 0.01f) {
            this.slack = 0.0f;
        }
        this.computeCatenary();
        this.world.m_6263_(null, hit.f_82479_, hit.f_82480_, hit.f_82481_, (SoundEvent)FLSounds.CORD_STRETCH.get(), SoundSource.BLOCKS, 1.0f, 0.8f + (3.0f - this.slack) * 0.4f);
        return true;
    }

    public void onConnect(Level world, Player user, ItemStack heldStack) {
    }

    protected void onRemove() {
    }

    protected void onUpdate() {
    }

    protected void onCalculateCatenary(boolean relocated) {
    }

    public final boolean update(Vec3 from) {
        this.prevCatenary = this.catenary;
        boolean changed = this.destination.get(this.world, false).map(dest -> {
            Vec3 point = dest.getConnectionPoint();
            boolean c = this.updateCatenary(from, (Fastener<?>)dest, point);
            this.onUpdate();
            double dist = point.m_82554_(from);
            double pull = dist - 32.0 + 5.0;
            if (pull > 0.0) {
                int stage = (int)(pull + (double)0.1f);
                if (stage > this.prevStretchStage) {
                    this.world.m_6263_(null, point.f_82479_, point.f_82480_, point.f_82481_, (SoundEvent)FLSounds.CORD_STRETCH.get(), SoundSource.BLOCKS, 0.25f, 0.5f + (float)stage / 8.0f);
                }
                this.prevStretchStage = stage;
            }
            if (dist > 37.0) {
                this.world.m_6263_(null, point.f_82479_, point.f_82480_, point.f_82481_, (SoundEvent)FLSounds.CORD_SNAP.get(), SoundSource.BLOCKS, 0.75f, 0.8f + this.world.f_46441_.m_188501_() * 0.3f);
                this.remove();
            } else if (dest.isMoving()) {
                dest.resistSnap(from);
            }
            return c;
        }).orElse(false);
        if (this.destination.isGone(this.world)) {
            this.remove();
        }
        return changed;
    }

    private boolean updateCatenary(Vec3 from, Fastener<?> dest, Vec3 point) {
        if (this.updateCatenary || this.isDynamic()) {
            Vec3 vec = point.m_82546_(from);
            if (vec.m_82553_() > 1.0E-6) {
                Direction facing = this.fastener.getFacing();
                this.catenary = this.fastener instanceof FenceFastener && dest instanceof FenceFastener && vec.m_165924_() < 0.01 ? this.verticalHelix(vec) : Catenary.from(vec, facing.m_122434_() == Direction.Axis.Y ? 0.0f : (float)Math.toRadians(90.0f + facing.m_122435_()), SLACK_CURVE, this.slack);
                this.onCalculateCatenary(!this.destination.equals(this.prevDestination));
                CollidableList.Builder bob = new CollidableList.Builder();
                this.addCollision(bob, from);
                this.collision = bob.build();
            }
            this.updateCatenary = false;
            this.prevDestination = this.destination;
            return true;
        }
        return false;
    }

    private Curve verticalHelix(Vec3 vec) {
        float length = (float)vec.m_82553_();
        float height = (float)vec.f_82480_;
        float stepSize = 0.25f;
        float loopsPerBlock = 1.0f;
        float radius = 0.33f;
        int steps = (int)(2.0734513f * length / 0.25f);
        float rad = (float)Math.PI * -2 * (1.0f * length);
        float[] x = new float[steps];
        float[] y = new float[steps];
        float[] z = new float[steps];
        float helixLength = 0.0f;
        for (int i = 0; i < steps; ++i) {
            float t = (float)i / (float)(steps - 1);
            x[i] = 0.33f * Mth.m_14089_((float)(t * rad));
            y[i] = t * height;
            z[i] = 0.33f * Mth.m_14031_((float)(t * rad));
            if (i <= 0) continue;
            helixLength += Mth.m_14116_((float)(Mth.m_14207_((float)(x[i] - x[i - 1])) + Mth.m_14207_((float)(y[i] - y[i - 1])) + Mth.m_14207_((float)(z[i] - z[i - 1]))));
        }
        return new Curve3d(steps, x, y, z, helixLength);
    }

    public void addCollision(CollidableList.Builder collision, Vec3 origin) {
        if (this.catenary == null) {
            return;
        }
        int count = this.catenary.getCount();
        if (count <= 2) {
            return;
        }
        float r = this.getRadius();
        Curve.SegmentIterator it = this.catenary.iterator();
        AABB[] bounds = new AABB[count - 1];
        int index = 0;
        while (it.next()) {
            float x0 = it.getX(0.0f);
            float y0 = it.getY(0.0f);
            float z0 = it.getZ(0.0f);
            float x1 = it.getX(1.0f);
            float y1 = it.getY(1.0f);
            float z1 = it.getZ(1.0f);
            bounds[index++] = new AABB(origin.f_82479_ + (double)x0, origin.f_82480_ + (double)y0, origin.f_82481_ + (double)z0, origin.f_82479_ + (double)x1, origin.f_82480_ + (double)y1, origin.f_82481_ + (double)z1).m_82400_((double)r);
        }
        collision.add(FeatureCollisionTree.build(CORD_FEATURE, i -> Segment.INSTANCE, i -> bounds[i], 1, bounds.length - 2));
    }

    public void deserialize(Fastener<?> destination, CompoundTag compound, boolean drop) {
        this.destination = destination.createAccessor();
        this.drop = drop;
        this.deserializeLogic(compound);
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("destination", (Tag)FastenerType.serialize(this.destination));
        compound.m_128365_("logic", (Tag)this.serializeLogic());
        compound.m_128350_("slack", this.slack);
        if (!this.drop) {
            compound.m_128379_("drop", false);
        }
        return compound;
    }

    @Override
    public void deserialize(CompoundTag compound) {
        this.destination = FastenerType.deserialize(compound.m_128469_("destination"));
        this.deserializeLogic(compound.m_128469_("logic"));
        this.slack = compound.m_128425_("slack", 99) ? compound.m_128457_("slack") : 1.0f;
        this.drop = !compound.m_128425_("drop", 99) || compound.m_128471_("drop");
        this.updateCatenary = true;
    }

    public CompoundTag serializeLogic() {
        return new CompoundTag();
    }

    public void deserializeLogic(CompoundTag compound) {
    }

    static class Segment
    implements Feature {
        static final Segment INSTANCE = new Segment();

        Segment() {
        }

        @Override
        public int getId() {
            return 0;
        }
    }
}

